<?php
session_start();

// Simple password
$password = "admin123";

// Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: admin.php");
    exit;
}

// Login check
if (!isset($_SESSION['logged_in'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['pass'] === $password) {
        $_SESSION['logged_in'] = true;
    } else {
        echo '<!DOCTYPE html><html><head>
        <title>Admin Login</title>
        <style>
        body {
            font-family: Montserrat, sans-serif;
            background: radial-gradient(circle at top, #0a0a0a, #111);
            color: white;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        form {
            background: rgba(255,255,255,0.05);
            border: 1px solid rgba(255,255,255,0.1);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 40px;
            text-align: center;
            width: 300px;
            box-shadow: 0 0 20px rgba(0,0,0,0.4);
        }
        input {
            padding: 10px;
            width: 90%;
            margin-top: 15px;
            border-radius: 8px;
            border: none;
            outline: none;
            background: rgba(255,255,255,0.1);
            color: white;
            font-size: 15px;
        }
        button {
            margin-top: 20px;
            padding: 10px 25px;
            border: none;
            border-radius: 10px;
            background: linear-gradient(90deg,#00c6ff,#007bff);
            color: white;
            font-size: 16px;
            cursor: pointer;
            transition: 0.3s;
        }
        button:hover { transform: scale(1.05); }
        h2 { margin-bottom: 10px; }
        </style></head><body>
        <form method="POST">
            <h2>🔒 Admin Login</h2>
            <input type="password" name="pass" placeholder="Enter Password"><br>
            <button type="submit">Login</button>
        </form>
        </body></html>';
        exit;
    }
}

// -------- CONFIG FILES --------
$configFile = 'config.json';
if (!file_exists($configFile)) {
    $config = ['status' => 'active', 'payment_mode' => 'test', 'last_change' => date('Y-m-d H:i:s')];
    file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));
}
$config = json_decode(file_get_contents($configFile), true);

// Field visibility config
$fieldFile = 'field.json';
if (!file_exists($fieldFile)) {
    $defaultFields = [
        'name' => true,
        'father_name' => true,
        'address' => true,
        'adhar' => true,
        'dob' => true,
        'photo' => true,
        'email' => true
    ];
    file_put_contents($fieldFile, json_encode($defaultFields, JSON_PRETTY_PRINT));
}
$fieldConfig = json_decode(file_get_contents($fieldFile), true);

// -------- AJAX HANDLERS --------
if (isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'toggle_site':
            $config['status'] = $config['status'] === 'active' ? 'off' : 'active';
            $config['last_change'] = date('Y-m-d H:i:s');
            file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));
            echo json_encode($config);
            exit;

        case 'toggle_payment':
            $config['payment_mode'] = $config['payment_mode'] === 'test' ? 'real' : 'test';
            $config['last_payment_change'] = date('Y-m-d H:i:s');
            file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));
            echo json_encode($config);
            exit;

        case 'toggle_field':
            $field = $_POST['field'];
            $fieldConfig[$field] = !$fieldConfig[$field];
            file_put_contents($fieldFile, json_encode($fieldConfig, JSON_PRETTY_PRINT));
            echo json_encode($fieldConfig);
            exit;
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Admin Control Panel</title>
<style>
body {
  font-family: Montserrat, sans-serif;
  background: radial-gradient(circle at top, #0b0b0b, #111);
  color: white;
  text-align: center;
  padding: 40px 0 100px;
  min-height: 100vh;
}
h1 { font-size: 2.2em; letter-spacing: 1px; margin-bottom: 30px; }
.section {
  background: rgba(255,255,255,0.05);
  backdrop-filter: blur(8px);
  border: 1px solid rgba(255,255,255,0.1);
  border-radius: 20px;
  padding: 25px;
  width: 85%;
  max-width: 600px;
  margin: 25px auto;
  box-shadow: 0 0 25px rgba(0,0,0,0.5);
  transition: 0.3s;
}
.section:hover { transform: translateY(-3px); }
button {
  background: linear-gradient(90deg,#00c6ff,#007bff);
  border: none;
  padding: 12px 25px;
  border-radius: 10px;
  color: white;
  font-size: 16px;
  cursor: pointer;
  margin: 10px;
  transition: 0.3s;
}
button:hover { transform: scale(1.05); }
.switch {
  display: flex; justify-content: space-between;
  align-items: center;
  margin: 10px 0; padding: 10px 15px;
  background: rgba(255,255,255,0.05);
  border-radius: 8px;
  border: 1px solid rgba(255,255,255,0.1);
}
.switch span { font-size: 17px; }
.toggle {
  width: 50px; height: 25px; border-radius: 15px;
  background: #555; position: relative; cursor: pointer;
  transition: 0.3s;
}
.toggle::after {
  content: ''; width: 21px; height: 21px;
  border-radius: 50%; background: white;
  position: absolute; top: 2px; left: 2px;
  transition: 0.3s;
}
.toggle.active { background: #00ff99; }
.toggle.active::after { left: 27px; }

#logoutBtn {
  position: fixed;
  top: 20px; right: 20px;
  background: #ff4d4d;
  font-size: 14px;
  padding: 8px 14px;
  border-radius: 8px;
}
.status { margin-top: 10px; font-size: 18px; }
.small { color: #aaa; font-size: 14px; }
footer {
  margin-top: 50px;
  font-size: 13px;
  color: #666;
}
</style>
</head>
<body>

<a id="logoutBtn" href="?logout">Logout</a>
<h1>🛠️ Admin Control Panel</h1>

<div class="section">
  <h2>🌐 Site Control</h2>
  <p class="status">Current Site: 
     <strong id="statusText" style="color:<?= $config['status']=='active'?'#00ff99':'#ff4d4d' ?>">
     <?= strtoupper($config['status']) ?></strong></p>
  <p class="small">Last Updated: <?= $config['last_change'] ?? 'N/A' ?></p>
  <button id="toggleSiteBtn">🔄 Toggle Site</button>
</div>

<div class="section">
  <h2>💳 Payment Mode</h2>
  <p class="status">Mode: 
     <strong id="payModeText" style="color:<?= $config['payment_mode']=='test'?'#ffd633':'#00ff99' ?>">
     <?= strtoupper($config['payment_mode']) ?></strong></p>
  <p class="small">Last Changed: <?= $config['last_payment_change'] ?? 'N/A' ?></p>
  <button id="togglePaymentBtn">💳 Switch Payment Mode</button>
</div>

<div class="section">
  <h2>👁️ Field Visibility</h2>
  <?php foreach ($fieldConfig as $field => $visible): ?>
  <div class="switch">
    <span><?= ucfirst(str_replace('_', ' ', $field)) ?></span>
    <div class="toggle <?= $visible ? 'active' : '' ?>" 
         onclick="toggleField('<?= $field ?>', this)"></div>
  </div>
  <?php endforeach; ?>
</div>

<footer>© <?= date('Y') ?> Admin Panel • Designed by You</footer>

<script>
// Toggle site
document.getElementById('toggleSiteBtn').addEventListener('click', () => {
  fetch('admin.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: 'action=toggle_site'
  }).then(r=>r.json()).then(data=>{
    document.getElementById('statusText').textContent = data.status.toUpperCase();
    document.getElementById('statusText').style.color = data.status==='active'?'#00ff99':'#ff4d4d';
  });
});

// Toggle payment
document.getElementById('togglePaymentBtn').addEventListener('click', () => {
  fetch('admin.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: 'action=toggle_payment'
  }).then(r=>r.json()).then(data=>{
    document.getElementById('payModeText').textContent = data.payment_mode.toUpperCase();
    document.getElementById('payModeText').style.color = data.payment_mode==='real'?'#00ff99':'#ffd633';
  });
});

// Toggle fields
function toggleField(field, el) {
  fetch('admin.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: 'action=toggle_field&field=' + field
  }).then(r=>r.json()).then(()=>{
    el.classList.toggle('active');
  });
}
</script>
</body>
</html>