<?php
require_once __DIR__ . '/../includes/auth.php';

requireAdmin();

$conn = getDBConnection();

// Get API logs
$sql = "SELECT * FROM api_logs ORDER BY request_time DESC LIMIT 100";
$result = $conn->query($sql);
$logs = [];
while ($row = $result->fetch_assoc()) {
    $logs[] = $row;
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Logs - Admin</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/admin.css">
</head>

<body>
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/admin-nav.php'; ?>

        <div class="admin-content">
            <div class="admin-header">
                <h1 class="admin-title">API Logs</h1>
                <a href="/app/api/logout.php" class="btn-logout-small">Logout</a>
            </div>

            <!-- Filter Tabs -->
            <div style="margin-bottom: 20px; display: flex; gap: 8px; border-bottom: 2px solid var(--border-color);">
                <button class="filter-btn active" data-filter="all" onclick="filterLogs('all')"
                    style="padding: 12px 24px; border: none; background: none; color: var(--text-primary); font-weight: 600; cursor: pointer; border-bottom: 3px solid #007AFF; transition: all 0.2s;">
                    All Logs
                </button>
                <button class="filter-btn" data-filter="mobile" onclick="filterLogs('mobile')"
                    style="padding: 12px 24px; border: none; background: none; color: var(--text-secondary); font-weight: 600; cursor: pointer; border-bottom: 3px solid transparent; transition: all 0.2s;">
                    📱 Mobile API
                </button>
                <button class="filter-btn" data-filter="ration" onclick="filterLogs('ration')"
                    style="padding: 12px 24px; border: none; background: none; color: var(--text-secondary); font-weight: 600; cursor: pointer; border-bottom: 3px solid transparent; transition: all 0.2s;">
                    🎫 Ration Card API
                </button>
            </div>

            <!-- Search Bar -->
            <div style="margin-bottom: 20px;">
                <input type="text" id="searchInput" placeholder="🔍 Search by number or aadhaar..."
                    style="width: 100%; padding: 12px 16px; border: 2px solid var(--border-color); border-radius: 12px; font-size: 15px; background: var(--bg-primary); color: var(--text-primary);"
                    onkeyup="searchTable()">
            </div>

            <div class="card">
                <p style="margin-bottom: 20px; color: var(--text-secondary);">
                    Showing last 100 API requests
                </p>

                <div class="table-responsive">
                    <table class="admin-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Type</th>
                                <th>Number/Aadhaar</th>
                                <th>Status</th>
                                <th>Error Message</th>
                                <th>Request Time</th>
                            </tr>
                        </thead>
                        <tbody id="logsTableBody">
                            <?php foreach ($logs as $log):
                                // Determine type based on mobile_number length or pattern
                                $number = $log['mobile_number'];
                                $isRation = strlen($number) == 12;
                                $type = $isRation ? 'ration' : 'mobile';
                                $icon = $isRation ? '🎫' : '📱';
                                ?>
                                <tr class="log-row" data-type="<?php echo $type; ?>">
                                    <td><?php echo $log['id']; ?></td>
                                    <td><span style="font-size: 18px;"><?php echo $icon; ?></span></td>
                                    <td><?php echo htmlspecialchars($log['mobile_number']); ?></td>
                                    <td>
                                        <span
                                            class="badge badge-<?php echo $log['status'] === 'success' ? 'db' : 'api'; ?>">
                                            <?php echo ucfirst($log['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo $log['error_message'] ? htmlspecialchars($log['error_message']) : '-'; ?>
                                    </td>
                                    <td><?php echo date('M d, Y h:i:s A', strtotime($log['request_time'])); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
        function filterLogs(filter) {
            // Update filter buttons
            document.querySelectorAll('.filter-btn').forEach(btn => {
                if (btn.getAttribute('data-filter') === filter) {
                    btn.classList.add('active');
                    btn.style.color = 'var(--text-primary)';
                    btn.style.borderBottom = '3px solid #007AFF';
                } else {
                    btn.classList.remove('active');
                    btn.style.color = 'var(--text-secondary)';
                    btn.style.borderBottom = '3px solid transparent';
                }
            });

            // Filter rows
            document.querySelectorAll('.log-row').forEach(row => {
                if (filter === 'all' || row.getAttribute('data-type') === filter) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        }

        function searchTable() {
            const input = document.getElementById('searchInput');
            const filter = input.value.toLowerCase();
            const rows = document.querySelectorAll('.log-row');

            rows.forEach(row => {
                const cells = row.getElementsByTagName('td');
                let found = false;

                // Search in number/aadhaar column (index 2)
                if (cells[2]) {
                    const text = cells[2].textContent || cells[2].innerText;
                    if (text.toLowerCase().indexOf(filter) > -1) {
                        found = true;
                    }
                }

                // Only hide if not found AND not already hidden by filter
                if (!found) {
                    row.style.display = 'none';
                } else if (row.style.display !== 'none') {
                    row.style.display = '';
                }
            });
        }
    </script>
    <script src="/app/assets/js/admin-menu.js"></script>
</body>

</html>