<?php
require_once __DIR__ . '/../includes/auth.php';

requireAdmin();

$conn = getDBConnection();

// Get all stored mobile data
$sql = "SELECT * FROM mobile_data ORDER BY created_at DESC";
$result = $conn->query($sql);
$mobileData = [];
while ($row = $result->fetch_assoc()) {
    $mobileData[] = $row;
}

// Get all stored ration card data
$sql = "SELECT * FROM ration_card_data ORDER BY created_at DESC";
$result = $conn->query($sql);
$rationData = [];
while ($row = $result->fetch_assoc()) {
    $rationData[] = $row;
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Stored Mobile Data - Admin</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/admin.css">
</head>

<body>
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/admin-nav.php'; ?>

        <div class="admin-content">
            <div class="admin-header">
                <h1 class="admin-title">Stored Data</h1>
                <a href="/app/api/logout.php" class="btn-logout-small">Logout</a>
            </div>

            <!-- Tabs -->
            <div style="margin-bottom: 20px; display: flex; gap: 8px; border-bottom: 2px solid var(--border-color);">
                <button class="tab-btn active" data-tab="mobile" onclick="switchTab('mobile')"
                    style="padding: 12px 24px; border: none; background: none; color: var(--text-primary); font-weight: 600; cursor: pointer; border-bottom: 3px solid #007AFF; transition: all 0.2s;">
                    📱 Mobile Data (<?php echo count($mobileData); ?>)
                </button>
                <button class="tab-btn" data-tab="ration" onclick="switchTab('ration')"
                    style="padding: 12px 24px; border: none; background: none; color: var(--text-secondary); font-weight: 600; cursor: pointer; border-bottom: 3px solid transparent; transition: all 0.2s;">
                    🎫 Ration Card Data (<?php echo count($rationData); ?>)
                </button>
            </div>

            <!-- Search Bar -->
            <div style="margin-bottom: 20px;">
                <input type="text" id="searchInput" placeholder="🔍 Search by number or aadhaar..."
                    style="width: 100%; padding: 12px 16px; border: 2px solid var(--border-color); border-radius: 12px; font-size: 15px; background: var(--bg-primary); color: var(--text-primary);"
                    onkeyup="searchTable()">
            </div>

            <!-- Mobile Data Table -->
            <div class="card tab-content" id="mobile-tab">
                <div class="table-responsive">
                    <table class="admin-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Mobile Number</th>
                                <th>Created</th>
                                <th>Last Updated</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($mobileData as $data): ?>
                                <tr>
                                    <td><?php echo $data['id']; ?></td>
                                    <td><?php echo htmlspecialchars($data['mobile_number']); ?></td>
                                    <td><?php echo date('M d, Y h:i A', strtotime($data['created_at'])); ?></td>
                                    <td><?php echo date('M d, Y h:i A', strtotime($data['updated_at'])); ?></td>
                                    <td>
                                        <button class="btn-action btn-edit"
                                            onclick="viewMobileData(<?php echo $data['id']; ?>)">View</button>
                                        <button class="btn-action btn-delete"
                                            onclick="deleteMobileData(<?php echo $data['id']; ?>)">Delete</button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Ration Card Data Table -->
            <div class="card tab-content" id="ration-tab" style="display: none;">
                <div class="table-responsive">
                    <table class="admin-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Aadhaar Number</th>
                                <th>Created</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($rationData as $data): ?>
                                <tr>
                                    <td><?php echo $data['id']; ?></td>
                                    <td><?php echo htmlspecialchars($data['aadhaar_number']); ?></td>
                                    <td><?php echo date('M d, Y h:i A', strtotime($data['created_at'])); ?></td>
                                    <td>
                                        <button class="btn-action btn-edit"
                                            onclick="viewRationData(<?php echo $data['id']; ?>)">View</button>
                                        <button class="btn-action btn-delete"
                                            onclick="deleteRationData(<?php echo $data['id']; ?>)">Delete</button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- View Data Modal -->
    <div id="viewModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Mobile Data</h3>
                <button class="modal-close" onclick="closeModal()">&times;</button>
            </div>
            <div id="dataContent"
                style="max-height: 400px; overflow-y: auto; padding: 16px; background: var(--bg-secondary); border-radius: 8px; font-family: monospace; font-size: 13px; white-space: pre-wrap; word-break: break-all;">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-primary" onclick="closeModal()">Close</button>
            </div>
        </div>
    </div>

    <div id="toast" class="toast"></div>

    <script>
        function switchTab(tab) {
            // Update tab buttons
            document.querySelectorAll('.tab-btn').forEach(btn => {
                if (btn.getAttribute('data-tab') === tab) {
                    btn.classList.add('active');
                    btn.style.color = 'var(--text-primary)';
                    btn.style.borderBottom = '3px solid #007AFF';
                } else {
                    btn.classList.remove('active');
                    btn.style.color = 'var(--text-secondary)';
                    btn.style.borderBottom = '3px solid transparent';
                }
            });

            // Update tab content
            document.querySelectorAll('.tab-content').forEach(content => {
                content.style.display = 'none';
            });
            document.getElementById(tab + '-tab').style.display = 'block';
        }

        function viewMobileData(id) {
            fetch(`/app/api/admin/get-mobile-data.php?id=${id}`)
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('dataContent').textContent = data.data.api_response;
                        document.getElementById('viewModal').classList.add('show');
                    }
                });
        }

        function viewRationData(id) {
            fetch(`/app/api/admin/get-ration-data.php?id=${id}`)
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('dataContent').textContent = JSON.stringify(JSON.parse(data.data.data), null, 2);
                        document.getElementById('viewModal').classList.add('show');
                    }
                });
        }

        function closeModal() {
            document.getElementById('viewModal').classList.remove('show');
        }

        function deleteMobileData(id) {
            if (!confirm('Are you sure you want to delete this mobile data? This action cannot be undone.')) return;

            fetch('/app/api/admin/delete-mobile-data.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ id })
            })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        showToast('Data deleted successfully', 'success');
                        setTimeout(() => location.reload(), 1000);
                    } else {
                        showToast(data.message || 'Delete failed', 'error');
                    }
                });
        }

        function deleteRationData(id) {
            if (!confirm('Are you sure you want to delete this ration card data? This action cannot be undone.')) return;

            fetch('/app/api/admin/delete-ration-data.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ id })
            })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        showToast('Data deleted successfully', 'success');
                        setTimeout(() => location.reload(), 1000);
                    } else {
                        showToast(data.message || 'Delete failed', 'error');
                    }
                });
        }

        function showToast(message, type = 'info') {
            const toast = document.getElementById('toast');
            toast.textContent = message;
            toast.className = `toast toast-${type} show`;
            setTimeout(() => toast.classList.remove('show'), 3000);
        }

        function searchTable() {
            const input = document.getElementById('searchInput');
            const filter = input.value.toLowerCase();
            const tables = document.querySelectorAll('.tab-content:not([style*="display: none"]) .admin-table tbody');

            tables.forEach(tbody => {
                const rows = tbody.getElementsByTagName('tr');
                for (let i = 0; i < rows.length; i++) {
                    const cells = rows[i].getElementsByTagName('td');
                    let found = false;

                    // Search in mobile number/aadhaar column (index 1)
                    if (cells[1]) {
                        const text = cells[1].textContent || cells[1].innerText;
                        if (text.toLowerCase().indexOf(filter) > -1) {
                            found = true;
                        }
                    }

                    rows[i].style.display = found ? '' : 'none';
                }
            });
        }
    </script>
    <script src="/app/assets/js/admin-menu.js"></script>
</body>

</html>