<?php
require_once __DIR__ . '/../includes/auth.php';

requireAdmin();

$conn = getDBConnection();

// Get all users with their permissions
$sql = "SELECT u.id, u.name, u.email, u.can_search_mobile, u.can_search_ration,
        p.dashboard, p.search, p.history, p.profile, p.support 
        FROM users u 
        LEFT JOIN user_nav_permissions p ON u.id = p.user_id 
        WHERE u.role = 'user' 
        ORDER BY u.name";
$result = $conn->query($sql);
$users = [];
while ($row = $result->fetch_assoc()) {
    $users[] = $row;
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Permissions - Admin</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/admin.css">
</head>

<body>
    <div class="admin-container">
        <?php include __DIR__ . '/../includes/admin-nav.php'; ?>

        <div class="admin-content">
            <div class="admin-header">
                <h1 class="admin-title">User Permissions</h1>
                <a href="/app/api/logout.php" class="btn-logout-small">Logout</a>
            </div>

            <!-- Search Bar -->
            <div style="margin-bottom: 20px;">
                <input type="text" id="searchInput" placeholder="🔍 Search by name or email..."
                    style="width: 100%; padding: 12px 16px; border: 2px solid var(--border-color); border-radius: 12px; font-size: 15px; background: var(--bg-primary); color: var(--text-primary);"
                    onkeyup="searchTable()">
            </div>

            <div class="card">
                <p style="margin-bottom: 20px; color: var(--text-secondary);">
                    Control navbar options and search types for each user. Disabled options will be hidden and
                    inaccessible.
                </p>

                <div class="table-responsive">
                    <table class="admin-table">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Email</th>
                                <th>Dashboard</th>
                                <th>Search</th>
                                <th>History</th>
                                <th>Profile</th>
                                <th>Support</th>
                                <th>📱 Mobile</th>
                                <th>🎫 Ration</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $colors = ['blue', 'pink', 'purple', 'orange', 'teal', 'red', 'indigo', 'green'];
                            $colorIndex = 0;
                            foreach ($users as $user):
                                $userColor = $colors[$colorIndex % count($colors)];
                                $colorIndex++;
                                ?>
                                <tr class="user-row-<?php echo $userColor; ?>">
                                    <td><?php echo htmlspecialchars($user['name']); ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td>
                                        <label class="toggle-switch">
                                            <input type="checkbox" <?php echo $user['dashboard'] ? 'checked' : ''; ?>
                                                onchange="togglePermission(<?php echo $user['id']; ?>, 'dashboard', this.checked)">
                                            <span class="toggle-slider"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <label class="toggle-switch">
                                            <input type="checkbox" <?php echo $user['search'] ? 'checked' : ''; ?>
                                                onchange="togglePermission(<?php echo $user['id']; ?>, 'search', this.checked)">
                                            <span class="toggle-slider"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <label class="toggle-switch">
                                            <input type="checkbox" <?php echo $user['history'] ? 'checked' : ''; ?>
                                                onchange="togglePermission(<?php echo $user['id']; ?>, 'history', this.checked)">
                                            <span class="toggle-slider"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <label class="toggle-switch">
                                            <input type="checkbox" <?php echo $user['profile'] ? 'checked' : ''; ?>
                                                onchange="togglePermission(<?php echo $user['id']; ?>, 'profile', this.checked)">
                                            <span class="toggle-slider"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <label class="toggle-switch">
                                            <input type="checkbox" <?php echo $user['support'] ? 'checked' : ''; ?>
                                                onchange="togglePermission(<?php echo $user['id']; ?>, 'support', this.checked)">
                                            <span class="toggle-slider"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <label class="toggle-switch">
                                            <input type="checkbox" <?php echo ($user['can_search_mobile'] ?? 1) ? 'checked' : ''; ?>
                                                onchange="toggleSearchType(<?php echo $user['id']; ?>, 'mobile', this.checked)">
                                            <span class="toggle-slider"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <label class="toggle-switch">
                                            <input type="checkbox" <?php echo ($user['can_search_ration'] ?? 1) ? 'checked' : ''; ?>
                                                onchange="toggleSearchType(<?php echo $user['id']; ?>, 'ration', this.checked)">
                                            <span class="toggle-slider"></span>
                                        </label>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div id="toast" class="toast"></div>

    <script>
        function togglePermission(userId, permission, enabled) {
            fetch('/app/api/admin/update-permission.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ userId, permission, enabled: enabled ? 1 : 0 })
            })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        showToast('Permission updated', 'success');
                    } else {
                        showToast(data.message || 'Update failed', 'error');
                    }
                });
        }

        function toggleSearchType(userId, searchType, enabled) {
            fetch('/app/api/admin/update-search-permission.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ userId, searchType, enabled: enabled ? 1 : 0 })
            })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        showToast('Search permission updated', 'success');
                    } else {
                        showToast(data.message || 'Update failed', 'error');
                    }
                });
        }

        function showToast(message, type = 'info') {
            const toast = document.getElementById('toast');
            toast.textContent = message;
            toast.className = `toast toast-${type} show`;
            setTimeout(() => toast.classList.remove('show'), 3000);
        }

        function searchTable() {
            const input = document.getElementById('searchInput');
            const filter = input.value.toLowerCase();
            const table = document.querySelector('.admin-table tbody');
            const rows = table.getElementsByTagName('tr');

            for (let i = 0; i < rows.length; i++) {
                const cells = rows[i].getElementsByTagName('td');
                let found = false;

                // Search in name (index 0) and email (index 1)
                for (let j = 0; j <= 1; j++) {
                    if (cells[j]) {
                        const text = cells[j].textContent || cells[j].innerText;
                        if (text.toLowerCase().indexOf(filter) > -1) {
                            found = true;
                            break;
                        }
                    }
                }

                rows[i].style.display = found ? '' : 'none';
            }
        }
    </script>
    <script src="/app/assets/js/admin-menu.js"></script>
</body>

</html>