<?php
require_once __DIR__ . '/../../includes/auth.php';

requireAdmin();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

$userId = (int) ($input['userId'] ?? 0);
$name = sanitizeInput($input['name'] ?? '');
$email = sanitizeInput($input['email'] ?? '');
$mobile = sanitizeInput($input['mobile'] ?? '');
$dailyLimit = (int) ($input['dailyLimit'] ?? 10);

if (!$userId || !$name || !$email || !$mobile) {
    echo json_encode(['success' => false, 'message' => 'All fields required']);
    exit;
}

$conn = getDBConnection();

$name = $conn->real_escape_string($name);
$email = $conn->real_escape_string($email);
$mobile = $conn->real_escape_string($mobile);

$sql = "UPDATE users SET 
        name = '$name', 
        email = '$email', 
        mobile = '$mobile', 
        daily_limit = $dailyLimit 
        WHERE id = $userId AND role = 'user'";

if ($conn->query($sql)) {
    echo json_encode(['success' => true, 'message' => 'User updated successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Update failed']);
}

$conn->close();
