<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../config/api.php';

// Allow both admin and user
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit;
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Check if search is enabled
$conn = getDBConnection();
$settingSql = "SELECT setting_value FROM settings WHERE setting_key = 'search_enabled'";
$result = $conn->query($settingSql);
$searchEnabled = true;
if ($result && $result->num_rows > 0) {
    $searchEnabled = (bool) $result->fetch_assoc()['setting_value'];
}

if (!$searchEnabled) {
    echo json_encode(['success' => false, 'message' => 'Search is currently disabled']);
    exit;
}

// Get input
$input = json_decode(file_get_contents('php://input'), true);
$mobileNumber = preg_replace('/[^0-9]/', '', $input['mobile_number'] ?? '');

if (empty($mobileNumber)) {
    echo json_encode(['success' => false, 'message' => 'Invalid mobile number']);
    exit;
}

// Check daily limit
$userId = (int) $_SESSION['user_id'];
$today = date('Y-m-d');

$limitSql = "SELECT daily_limit FROM users WHERE id = $userId";
$limitResult = $conn->query($limitSql);
$dailyLimit = 10;
if ($limitResult && $limitResult->num_rows > 0) {
    $dailyLimit = (int) $limitResult->fetch_assoc()['daily_limit'];
}

$countSql = "SELECT COUNT(*) as count FROM search_logs 
             WHERE user_id = $userId AND DATE(search_date) = '$today'";
$countResult = $conn->query($countSql);
$searchesToday = 0;
if ($countResult && $countResult->num_rows > 0) {
    $searchesToday = (int) $countResult->fetch_assoc()['count'];
}

if ($searchesToday >= $dailyLimit) {
    echo json_encode(['success' => false, 'message' => 'Daily search limit reached']);
    exit;
}

// Check if mobile number exists in database
$mobile = $conn->real_escape_string($mobileNumber);
$checkSql = "SELECT api_response, created_at FROM mobile_data WHERE mobile_number = '$mobile'";
$checkResult = $conn->query($checkSql);

$source = 'API';
$apiResponse = null;

if ($checkResult && $checkResult->num_rows > 0) {
    // Found in database
    $row = $checkResult->fetch_assoc();
    $apiResponse = $row['api_response'];
    $source = 'DB';
} else {
    // Not found - call API
    $apiResult = fetchFromAPI($mobileNumber);

    if ($apiResult['success']) {
        $apiResponse = $apiResult['raw_json'];
        // Store in database
        storeAPIResponse($mobileNumber, $apiResponse);
        $source = 'API';
    } else {
        // API failed - show helpful message
        echo json_encode([
            'success' => false,
            'message' => 'No data found for this number',
            'details' => 'This number is not in our database yet. The external API is currently unavailable. Please try again later or contact support.',
            'error_type' => 'not_found',
            'searched_number' => $mobileNumber
        ]);
        exit;
    }
}

// Log the search
$logSql = "INSERT INTO search_logs (user_id, mobile_number, source) 
           VALUES ($userId, '$mobile', '$source')";
$conn->query($logSql);

$conn->close();

// Parse API response if it's a string
if (is_string($apiResponse)) {
    $parsedResponse = json_decode($apiResponse, true);

    // Check if response has 'result' array (new API format)
    if (isset($parsedResponse['result']) && is_array($parsedResponse['result'])) {
        // Use the result array directly
        $apiResponse = $parsedResponse['result'];
    }
    // Check if response has 'results' array (old API format)
    elseif (isset($parsedResponse['results']) && is_array($parsedResponse['results'])) {
        // Use the results array directly
        $apiResponse = $parsedResponse['results'];
    } else {
        // Use as is
        $apiResponse = $parsedResponse;
    }
}

// Return result
echo json_encode([
    'success' => true,
    'mobile_number' => $mobileNumber,
    'data' => $apiResponse,
    'source' => $source,
    'message' => 'Search completed successfully'
]);
