<?php
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: application/json');
requireUser();

$userId = (int) $_SESSION['user_id'];
$conn = getDBConnection();

// Get request data
$data = json_decode(file_get_contents('php://input'), true);
$aadhaar = sanitizeInput($data['aadhaar'] ?? '');

if (empty($aadhaar) || !preg_match('/^[0-9]{12}$/', $aadhaar)) {
    echo json_encode(['success' => false, 'message' => 'Invalid Aadhaar number']);
    exit;
}

// Check daily limit
$today = date('Y-m-d');
$sql = "SELECT COUNT(*) as count FROM search_logs WHERE user_id = $userId AND DATE(search_date) = '$today'";
$result = $conn->query($sql);
$searchesToday = $result->fetch_assoc()['count'];

$sql = "SELECT daily_limit FROM users WHERE id = $userId";
$result = $conn->query($sql);
$user = $result->fetch_assoc();
$dailyLimit = (int) $user['daily_limit'];

if ($searchesToday >= $dailyLimit) {
    echo json_encode(['success' => false, 'message' => 'Daily search limit reached']);
    exit;
}

// Check if already in database
$sql = "SELECT * FROM ration_card_data WHERE aadhaar_number = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('s', $aadhaar);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Found in database
    $dbData = $result->fetch_assoc();

    // Log to API logs table
    $sql = "INSERT INTO api_logs (mobile_number, status, request_time) VALUES (?, 'success', NOW())";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $aadhaar);
    $stmt->execute();

    // Log search
    $sql = "INSERT INTO search_logs (user_id, mobile_number, source, search_type) VALUES (?, ?, 'database', 'ration_card')";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('is', $userId, $aadhaar);
    $stmt->execute();

    echo json_encode([
        'success' => true,
        'source' => 'database',
        'data' => json_decode($dbData['data'], true)
    ]);
    exit;
}

// Call API
$apiUrl = "https://aniketh-family.gauravyt566.workers.dev/?aadhaar=" . $aadhaar;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

if ($httpCode !== 200 || empty($response)) {
    $errorMsg = 'API request failed';
    if ($curlError) {
        $errorMsg .= ': ' . $curlError;
    }
    if ($httpCode) {
        $errorMsg .= ' (HTTP ' . $httpCode . ')';
    }

    // Log to API logs table
    $sql = "INSERT INTO api_logs (mobile_number, status, error_message, request_time) VALUES (?, 'failed', ?, NOW())";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('ss', $aadhaar, $errorMsg);
    $stmt->execute();

    // Log for debugging
    error_log("Ration Card API Error: $errorMsg - URL: $apiUrl");

    echo json_encode([
        'success' => false,
        'message' => $errorMsg,
        'debug' => [
            'url' => $apiUrl,
            'http_code' => $httpCode,
            'curl_error' => $curlError,
            'response' => substr($response, 0, 200)
        ]
    ]);
    exit;
}

$apiData = json_decode($response, true);

if (!$apiData || !isset($apiData['success']) || !$apiData['success']) {
    echo json_encode(['success' => false, 'message' => 'No data found']);
    exit;
}

// Additional validation - check if result has actual data
if (!isset($apiData['result']['results']) || empty($apiData['result']['results'])) {
    echo json_encode(['success' => false, 'message' => 'No ration card data found for this Aadhaar number']);
    exit;
}

// Check if result.success is false (API error)
if (isset($apiData['result']['success']) && $apiData['result']['success'] === false) {
    $errorMsg = $apiData['result']['error'] ?? 'API returned error';
    echo json_encode(['success' => false, 'message' => $errorMsg]);
    exit;
}

// Save to database (no duplicates)
$dataJson = json_encode($apiData);
$sql = "INSERT INTO ration_card_data (aadhaar_number, data, created_at) VALUES (?, ?, NOW()) 
        ON DUPLICATE KEY UPDATE data = VALUES(data), updated_at = NOW()";
$stmt = $conn->prepare($sql);
$stmt->bind_param('ss', $aadhaar, $dataJson);
$stmt->execute();

// Log to API logs table
$sql = "INSERT INTO api_logs (mobile_number, status, request_time) VALUES (?, 'success', NOW())";
$stmt = $conn->prepare($sql);
$stmt->bind_param('s', $aadhaar);
$stmt->execute();

// Log search
$sql = "INSERT INTO search_logs (user_id, mobile_number, source, search_type) VALUES (?, ?, 'api', 'ration_card')";
$stmt = $conn->prepare($sql);
$stmt->bind_param('is', $userId, $aadhaar);
$stmt->execute();

$conn->close();

echo json_encode([
    'success' => true,
    'source' => 'api',
    'data' => $apiData
]);
