<?php
require_once __DIR__ . '/../../includes/auth.php';

header('Content-Type: application/json');

requireUser();

$userId = (int) $_SESSION['user_id'];
$conn = getDBConnection();

// Get all referrals with user details
$sql = "SELECT 
            u.name,
            u.email,
            u.daily_limit as total_searches,
            u.created_at,
            r.created_at as referred_at,
            r.reward_given
        FROM referrals r
        JOIN users u ON r.referee_id = u.id
        WHERE r.referrer_id = $userId
        ORDER BY r.created_at DESC";

$result = $conn->query($sql);

$referrals = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $referrals[] = [
            'name' => $row['name'],
            'email' => $row['email'],
            'total_searches' => $row['total_searches'],
            'joined_date' => date('M d, Y', strtotime($row['created_at'])),
            'referred_date' => date('M d, Y', strtotime($row['referred_at'])),
            'reward_earned' => $row['reward_given']
        ];
    }
}

$conn->close();

echo json_encode([
    'success' => true,
    'total' => count($referrals),
    'referrals' => $referrals
]);
