// Admin Mobile Menu Toggle
document.addEventListener('DOMContentLoaded', function () {
    // Create mobile header if not exists
    const adminContainer = document.querySelector('.admin-container');
    if (adminContainer && !document.querySelector('.admin-mobile-header')) {
        const currentPage = document.querySelector('.admin-title')?.textContent || 'Admin Panel';

        const mobileHeader = document.createElement('div');
        mobileHeader.className = 'admin-mobile-header';
        mobileHeader.innerHTML = `
            <button class="menu-toggle" id="menuToggle">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="3" y1="12" x2="21" y2="12"></line>
                    <line x1="3" y1="6" x2="21" y2="6"></line>
                    <line x1="3" y1="18" x2="21" y2="18"></line>
                </svg>
            </button>
            <h1 class="admin-mobile-title">${currentPage}</h1>
            <div style="width: 24px;"></div>
        `;

        adminContainer.insertBefore(mobileHeader, adminContainer.firstChild);
    }

    // Create overlay if not exists
    if (!document.querySelector('.sidebar-overlay')) {
        const overlay = document.createElement('div');
        overlay.className = 'sidebar-overlay';
        overlay.id = 'sidebarOverlay';
        document.body.appendChild(overlay);
    }

    const menuToggle = document.getElementById('menuToggle');
    const sidebar = document.querySelector('.admin-sidebar');
    const overlay = document.getElementById('sidebarOverlay');

    if (menuToggle && sidebar && overlay) {
        // Toggle menu
        menuToggle.addEventListener('click', function () {
            sidebar.classList.toggle('open');
            overlay.classList.toggle('show');
        });

        // Close on overlay click
        overlay.addEventListener('click', function () {
            sidebar.classList.remove('open');
            overlay.classList.remove('show');
        });

        // Close on menu item click (mobile)
        const menuItems = sidebar.querySelectorAll('.admin-menu-item');
        menuItems.forEach(item => {
            item.addEventListener('click', function () {
                if (window.innerWidth < 768) {
                    sidebar.classList.remove('open');
                    overlay.classList.remove('show');
                }
            });
        });
    }
});
