// Admin Users Management

function editUser(userId) {
    fetch(`/app/api/admin/get-user.php?id=${userId}`)
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                document.getElementById('editUserId').value = data.user.id;
                document.getElementById('editName').value = data.user.name;
                document.getElementById('editEmail').value = data.user.email;
                document.getElementById('editMobile').value = data.user.mobile;
                document.getElementById('editDailyLimit').value = data.user.daily_limit;
                document.getElementById('editModal').classList.add('show');
            }
        });
}

function closeModal() {
    document.getElementById('editModal').classList.remove('show');
}

document.getElementById('editForm').addEventListener('submit', async (e) => {
    e.preventDefault();

    const userId = document.getElementById('editUserId').value;
    const name = document.getElementById('editName').value;
    const email = document.getElementById('editEmail').value;
    const mobile = document.getElementById('editMobile').value;
    const dailyLimit = document.getElementById('editDailyLimit').value;

    try {
        const response = await fetch('/app/api/admin/update-user.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ userId, name, email, mobile, dailyLimit })
        });

        const data = await response.json();

        if (data.success) {
            showToast('User updated successfully', 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            showToast(data.message || 'Update failed', 'error');
        }
    } catch (error) {
        showToast('Network error', 'error');
    }
});

function toggleStatus(userId, currentStatus) {
    const newStatus = currentStatus === 'active' ? 'blocked' : 'active';
    const action = newStatus === 'blocked' ? 'block' : 'activate';

    if (!confirm(`Are you sure you want to ${action} this user?`)) return;

    fetch('/app/api/admin/toggle-status.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ userId, status: newStatus })
    })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                showToast(`User ${action}d successfully`, 'success');
                setTimeout(() => location.reload(), 1000);
            } else {
                showToast(data.message || 'Action failed', 'error');
            }
        });
}

async function deleteUser(userId) {
    if (!confirm('Are you sure you want to delete this user? This action cannot be undone.')) {
        return;
    }

    try {
        const response = await fetch('/app/api/admin/delete-user.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ userId: parseInt(userId) })
        });

        const text = await response.text();
        console.log('Response:', text);

        if (!text) {
            throw new Error('Empty response');
        }

        const data = JSON.parse(text);

        if (data.success) {
            showToast('User deleted successfully', 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            showToast(data.message || 'Delete failed', 'error');
        }
    } catch (error) {
        console.error('Error:', error);
        showToast('Error: ' + error.message, 'error');
    }
}

function toggleSearchType(userId, searchType, enabled) {
    fetch('/app/api/admin/update-search-permission.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ userId, searchType, enabled: enabled ? 1 : 0 })
    })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                showToast(`${searchType === 'mobile' ? 'Mobile' : 'Ration Card'} search ${enabled ? 'enabled' : 'disabled'}`, 'success');
            } else {
                showToast(data.message || 'Update failed', 'error');
            }
        })
        .catch(error => {
            showToast('Network error', 'error');
        });
}

function showToast(message, type = 'info') {
    const toast = document.getElementById('toast');
    toast.textContent = message;
    toast.className = `toast toast-${type} show`;
    setTimeout(() => toast.classList.remove('show'), 3000);
}
