<?php
/**
 * API Configuration
 * Hardcoded API credentials - NEVER expose to frontend
 */

// API Configuration (BACKEND ONLY)
define('API_URL', 'https://aniketh.gauravyt566.workers.dev/');
define('API_KEY', 'Gaur');

/**
 * Fetch mobile number information from external API
 * @param string $mobileNumber
 * @return array|null
 */
function fetchFromAPI($mobileNumber)
{
    // Validate mobile number
    $mobileNumber = preg_replace('/[^0-9]/', '', $mobileNumber);

    if (empty($mobileNumber)) {
        return null;
    }

    // Prepare API request
    $url = API_URL . '?key=' . urlencode(API_KEY) . '&mobile=' . urlencode($mobileNumber);

    // Try cURL first
    if (function_exists('curl_init')) {
        $result = fetchViaCurl($url, $mobileNumber);
        if ($result !== false) {
            return $result;
        }
    }

    // Fallback to file_get_contents
    return fetchViaFileGetContents($url, $mobileNumber);
}

/**
 * Fetch using cURL
 */
function fetchViaCurl($url, $mobileNumber)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
        'User-Agent: MobileSearchPro/1.0'
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    // Log API call
    logAPICall($mobileNumber, $httpCode, $response, $error);

    // Handle response
    if ($httpCode === 200 && !empty($response)) {
        return [
            'success' => true,
            'data' => $response,
            'raw_json' => $response
        ];
    }

    // Return false to try fallback
    return false;
}

/**
 * Fallback using file_get_contents
 */
function fetchViaFileGetContents($url, $mobileNumber)
{
    $context = stream_context_create([
        'http' => [
            'method' => 'GET',
            'header' => "Accept: application/json\r\n" .
                "User-Agent: MobileSearchPro/1.0\r\n",
            'timeout' => 30,
            'ignore_errors' => true
        ],
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false
        ]
    ]);

    $response = @file_get_contents($url, false, $context);

    if ($response !== false && !empty($response)) {
        logAPICall($mobileNumber, 200, $response, null);
        return [
            'success' => true,
            'data' => $response,
            'raw_json' => $response
        ];
    } else {
        $error = 'Failed to connect to API server';
        logAPICall($mobileNumber, 0, null, $error);
        return [
            'success' => false,
            'error' => $error,
            'http_code' => 0
        ];
    }
}

/**
 * Log API calls to database
 */
function logAPICall($mobileNumber, $httpCode, $response, $error)
{
    $conn = getDBConnection();

    $status = ($httpCode === 200 && !empty($response)) ? 'success' : 'failed';
    $errorMsg = $error ?: ($httpCode !== 200 ? "HTTP Error: $httpCode" : null);

    $mobile = $conn->real_escape_string($mobileNumber);
    $errorMsg = $errorMsg ? $conn->real_escape_string($errorMsg) : null;

    $sql = "INSERT INTO api_logs (mobile_number, status, error_message) 
            VALUES ('$mobile', '$status', " . ($errorMsg ? "'$errorMsg'" : "NULL") . ")";

    $conn->query($sql);
    $conn->close();
}

/**
 * Store API response in database
 */
function storeAPIResponse($mobileNumber, $jsonResponse)
{
    $conn = getDBConnection();

    $mobile = $conn->real_escape_string($mobileNumber);
    $json = $conn->real_escape_string($jsonResponse);

    // Check if already exists
    $checkSql = "SELECT id FROM mobile_data WHERE mobile_number = '$mobile'";
    $result = $conn->query($checkSql);

    if ($result->num_rows > 0) {
        // Update existing
        $sql = "UPDATE mobile_data SET api_response = '$json', updated_at = CURRENT_TIMESTAMP 
                WHERE mobile_number = '$mobile'";
    } else {
        // Insert new
        $sql = "INSERT INTO mobile_data (mobile_number, api_response) VALUES ('$mobile', '$json')";
    }

    $success = $conn->query($sql);
    $conn->close();

    return $success;
}

/**
 * Get mobile data from database
 */
function getMobileDataFromDB($mobileNumber)
{
    $conn = getDBConnection();

    $mobile = $conn->real_escape_string($mobileNumber);
    $sql = "SELECT api_response, created_at FROM mobile_data WHERE mobile_number = '$mobile'";

    $result = $conn->query($sql);
    $data = null;

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $data = [
            'success' => true,
            'data' => $row['api_response'],
            'cached_at' => $row['created_at'],
            'source' => 'DB'
        ];
    }

    $conn->close();
    return $data;
}
