<?php
/**
 * Database Configuration
 * Secure database connection settings
 * Auto-detects localhost vs live server
 */

// Detect environment - includes local network IPs
$serverName = $_SERVER['SERVER_NAME'] ?? $_SERVER['HTTP_HOST'] ?? 'localhost';
$isLocalhost = in_array($serverName, ['localhost', '127.0.0.1', '::1']) ||
    preg_match('/^(10\.|192\.168\.|172\.(1[6-9]|2[0-9]|3[01])\.)/i', $serverName);

if ($isLocalhost) {
    // Localhost configuration (includes local network)
    define('DB_HOST', 'localhost');
    define('DB_USER', 'root');
    define('DB_PASS', '');
    define('DB_NAME', 'mobile_search_platform');
} else {
    // Live server configuration
    define('DB_HOST', 'localhost');
    define('DB_USER', 'iplztpse_bca');
    define('DB_PASS', 'B76M#[Q)SO2L');
    define('DB_NAME', 'iplztpse_bca');
}

// Create connection
function getDBConnection()
{
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

    if ($conn->connect_error) {
        error_log("Database connection failed: " . $conn->connect_error);
        die("Connection failed. Please try again later.");
    }

    $conn->set_charset("utf8mb4");
    return $conn;
}

// Initialize database and tables
function initializeDatabase()
{
    // Connect without database
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS);

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Create database if not exists
    $sql = "CREATE DATABASE IF NOT EXISTS " . DB_NAME . " CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";
    $conn->query($sql);

    $conn->select_db(DB_NAME);

    // Create users table
    $sql = "CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) NOT NULL,
        email VARCHAR(100) UNIQUE NOT NULL,
        mobile VARCHAR(20) NOT NULL,
        password VARCHAR(255) NOT NULL,
        role ENUM('user', 'admin') DEFAULT 'user',
        status ENUM('active', 'blocked') DEFAULT 'active',
        daily_limit INT DEFAULT 10,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_email (email),
        INDEX idx_role (role),
        INDEX idx_status (status)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    $conn->query($sql);

    // Create user_nav_permissions table
    $sql = "CREATE TABLE IF NOT EXISTS user_nav_permissions (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        dashboard TINYINT(1) DEFAULT 1,
        search TINYINT(1) DEFAULT 1,
        history TINYINT(1) DEFAULT 1,
        profile TINYINT(1) DEFAULT 1,
        support TINYINT(1) DEFAULT 1,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        UNIQUE KEY unique_user (user_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    $conn->query($sql);

    // Create mobile_data table
    $sql = "CREATE TABLE IF NOT EXISTS mobile_data (
        id INT AUTO_INCREMENT PRIMARY KEY,
        mobile_number VARCHAR(20) UNIQUE NOT NULL,
        api_response LONGTEXT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        UNIQUE KEY unique_mobile (mobile_number),
        INDEX idx_mobile (mobile_number)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    $conn->query($sql);

    // Create search_logs table
    $sql = "CREATE TABLE IF NOT EXISTS search_logs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        mobile_number VARCHAR(20) NOT NULL,
        source ENUM('DB', 'API') NOT NULL,
        search_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_user (user_id),
        INDEX idx_date (search_date)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    $conn->query($sql);

    // Create api_logs table
    $sql = "CREATE TABLE IF NOT EXISTS api_logs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        mobile_number VARCHAR(20) NOT NULL,
        status ENUM('success', 'failed') NOT NULL,
        error_message TEXT,
        request_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_status (status),
        INDEX idx_time (request_time)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    $conn->query($sql);

    // Create settings table
    $sql = "CREATE TABLE IF NOT EXISTS settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        setting_key VARCHAR(100) UNIQUE NOT NULL,
        setting_value TEXT NOT NULL,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    $conn->query($sql);

    // Insert default settings
    $defaultSettings = [
        ['search_enabled', '1'],
        ['default_daily_limit', '10'],
        ['maintenance_mode', '0'],
        ['app_name', 'Mobile Search Pro']
    ];

    foreach ($defaultSettings as $setting) {
        $key = $conn->real_escape_string($setting[0]);
        $value = $conn->real_escape_string($setting[1]);
        $sql = "INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('$key', '$value')";
        $conn->query($sql);
    }

    // Create default admin if not exists
    $adminEmail = 'admin@admin.com';
    $adminPassword = password_hash('admin123', PASSWORD_BCRYPT);

    $sql = "INSERT IGNORE INTO users (name, email, mobile, password, role, status, daily_limit) 
            VALUES ('Admin', '$adminEmail', '9999999999', '$adminPassword', 'admin', 'active', 999999)";
    $conn->query($sql);

    $conn->close();
}
