$apiAdminFiles = Get-ChildItem 'c:\xampp\htdocs\app\api\admin\*.php'

foreach ($file in $apiAdminFiles) {
    $content = Get-Content $file.FullName -Raw
    
    # Fix the include path
    $content = $content -replace "require_once __DIR__ \. '/\.\./\.\./\.\./includes/auth\.php';", "require_once __DIR__ . '/../../includes/auth.php';"
    
    Set-Content $file.FullName $content -NoNewline
    Write-Host "Fixed: $($file.Name)"
}

Write-Host "`nAll admin API files fixed!"
