<?php
$permissions = getUserNavPermissions();
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>

<nav class="bottom-nav">
    <!-- Dashboard -->
    <a href="<?php echo $permissions['dashboard'] ? '/app/user/dashboard.php' : '#'; ?>"
        class="nav-item <?php echo $currentPage === 'dashboard' ? 'active' : ''; ?> <?php echo !$permissions['dashboard'] ? 'locked' : ''; ?>"
        <?php if (!$permissions['dashboard']): ?>onclick="event.preventDefault(); showLockMessage('Dashboard');" <?php endif; ?>>
        <div class="nav-icon-wrapper">
            <svg class="nav-icon" viewBox="0 0 24 24" fill="none">
                <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z" fill="currentColor" />
            </svg>
            <?php if (!$permissions['dashboard']): ?>
                <span class="lock-icon">🔒</span>
            <?php endif; ?>
        </div>
        <span class="nav-label">Dashboard</span>
    </a>

    <!-- Search -->
    <a href="<?php echo $permissions['search'] ? '/app/user/search.php' : '#'; ?>"
        class="nav-item <?php echo $currentPage === 'search' ? 'active' : ''; ?> <?php echo !$permissions['search'] ? 'locked' : ''; ?>"
        <?php if (!$permissions['search']): ?>onclick="event.preventDefault(); showLockMessage('Search');" <?php endif; ?>>
        <div class="nav-icon-wrapper">
            <svg class="nav-icon" viewBox="0 0 24 24" fill="none">
                <path
                    d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"
                    fill="currentColor" />
            </svg>
            <?php if (!$permissions['search']): ?>
                <span class="lock-icon">🔒</span>
            <?php endif; ?>
        </div>
        <span class="nav-label">Search</span>
    </a>

    <!-- History -->
    <a href="<?php echo $permissions['history'] ? '/app/user/history.php' : '#'; ?>"
        class="nav-item <?php echo $currentPage === 'history' ? 'active' : ''; ?> <?php echo !$permissions['history'] ? 'locked' : ''; ?>"
        <?php if (!$permissions['history']): ?>onclick="event.preventDefault(); showLockMessage('History');" <?php endif; ?>>
        <div class="nav-icon-wrapper">
            <svg class="nav-icon" viewBox="0 0 24 24" fill="none">
                <path
                    d="M13 3c-4.97 0-9 4.03-9 9H1l3.89 3.89.07.14L9 12H6c0-3.87 3.13-7 7-7s7 3.13 7 7-3.13 7-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42C8.27 19.99 10.51 21 13 21c4.97 0 9-4.03 9-9s-4.03-9-9-9zm-1 5v5l4.28 2.54.72-1.21-3.5-2.08V8H12z"
                    fill="currentColor" />
            </svg>
            <?php if (!$permissions['history']): ?>
                <span class="lock-icon">🔒</span>
            <?php endif; ?>
        </div>
        <span class="nav-label">History</span>
    </a>

    <!-- Profile -->
    <a href="<?php echo $permissions['profile'] ? '/app/user/profile.php' : '#'; ?>"
        class="nav-item <?php echo $currentPage === 'profile' ? 'active' : ''; ?> <?php echo !$permissions['profile'] ? 'locked' : ''; ?>"
        <?php if (!$permissions['profile']): ?>onclick="event.preventDefault(); showLockMessage('Profile');" <?php endif; ?>>
        <div class="nav-icon-wrapper">
            <svg class="nav-icon" viewBox="0 0 24 24" fill="none">
                <path
                    d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"
                    fill="currentColor" />
            </svg>
            <?php if (!$permissions['profile']): ?>
                <span class="lock-icon">🔒</span>
            <?php endif; ?>
        </div>
        <span class="nav-label">Profile</span>
    </a>

    <!-- Support -->
    <a href="<?php echo $permissions['support'] ? '/app/user/support.php' : '#'; ?>"
        class="nav-item <?php echo $currentPage === 'support' ? 'active' : ''; ?> <?php echo !$permissions['support'] ? 'locked' : ''; ?>"
        <?php if (!$permissions['support']): ?>onclick="event.preventDefault(); showLockMessage('Support');" <?php endif; ?>>
        <div class="nav-icon-wrapper">
            <svg class="nav-icon" viewBox="0 0 24 24" fill="none">
                <path
                    d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z"
                    fill="currentColor" />
            </svg>
            <?php if (!$permissions['support']): ?>
                <span class="lock-icon">🔒</span>
            <?php endif; ?>
        </div>
        <span class="nav-label">Support</span>
    </a>
</nav>

<script>
    function showLockMessage(feature) {
        const toast = document.getElementById('toast');
        if (toast) {
            toast.textContent = `${feature} is locked. Contact admin to unlock.`;
            toast.className = 'toast toast-warning show';
            setTimeout(() => toast.classList.remove('show'), 3000);
        } else {
            alert(`${feature} is locked. Contact admin to unlock.`);
        }
    }
</script>