<?php
/**
 * Database Initialization Script
 * Run this file once to set up the database and tables
 */

require_once __DIR__ . '/config/database.php';

echo "<!DOCTYPE html>";
echo "<html><head><title>Database Setup</title>";
echo "<style>
    body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif; padding: 40px; background: #f5f5f5; }
    .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 12px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    h1 { color: #007AFF; margin-bottom: 20px; }
    .success { color: #34C759; padding: 10px; background: #e8f5e9; border-radius: 6px; margin: 10px 0; }
    .error { color: #FF3B30; padding: 10px; background: #ffebee; border-radius: 6px; margin: 10px 0; }
    .info { color: #007AFF; padding: 10px; background: #e3f2fd; border-radius: 6px; margin: 10px 0; }
    code { background: #f5f5f5; padding: 2px 6px; border-radius: 4px; }
</style>";
echo "</head><body>";
echo "<div class='container'>";
echo "<h1>🚀 Mobile Search Pro - Database Setup</h1>";

try {
    // Initialize database
    initializeDatabase();

    echo "<div class='success'>✓ Database created successfully!</div>";
    echo "<div class='success'>✓ All tables created successfully!</div>";
    echo "<div class='success'>✓ Default settings configured!</div>";
    echo "<div class='success'>✓ Admin account created!</div>";

    echo "<div class='info'>";
    echo "<h3>📋 Setup Complete!</h3>";
    echo "<p><strong>Admin Credentials:</strong></p>";
    echo "<p>Email: <code>admin@admin.com</code></p>";
    echo "<p>Password: <code>admin123</code></p>";
    echo "<p style='margin-top: 20px;'><strong>Next Steps:</strong></p>";
    echo "<ol>";
    echo "<li>Update API credentials in <code>/config/api.php</code></li>";
    echo "<li>Delete this file (<code>init.php</code>) for security</li>";
    echo "<li><a href='login.php' style='color: #007AFF;'>Go to Login Page</a></li>";
    echo "</ol>";
    echo "</div>";

} catch (Exception $e) {
    echo "<div class='error'>✗ Error: " . $e->getMessage() . "</div>";
}

echo "</div>";
echo "</body></html>";
