-- Performance Optimization: Add Database Indexes (Safe to run multiple times)

-- Users table indexes
ALTER TABLE `users` ADD INDEX IF NOT EXISTS `idx_email` (`email`);
ALTER TABLE `users` ADD INDEX IF NOT EXISTS `idx_role` (`role`);
ALTER TABLE `users` ADD INDEX IF NOT EXISTS `idx_status` (`status`);

-- Search logs indexes
ALTER TABLE `search_logs` ADD INDEX IF NOT EXISTS `idx_user_date` (`user_id`, `search_date`);
ALTER TABLE `search_logs` ADD INDEX IF NOT EXISTS `idx_search_type` (`search_type`);
ALTER TABLE `search_logs` ADD INDEX IF NOT EXISTS `idx_mobile` (`mobile_number`);

-- Mobile data indexes
ALTER TABLE `mobile_data` ADD INDEX IF NOT EXISTS `idx_mobile_number` (`mobile_number`);
ALTER TABLE `mobile_data` ADD INDEX IF NOT EXISTS `idx_created` (`created_at`);

-- Ration card data indexes
ALTER TABLE `ration_card_data` ADD INDEX IF NOT EXISTS `idx_aadhaar` (`aadhaar_number`);
ALTER TABLE `ration_card_data` ADD INDEX IF NOT EXISTS `idx_created` (`created_at`);

-- API logs indexes
ALTER TABLE `api_logs` ADD INDEX IF NOT EXISTS `idx_mobile` (`mobile_number`);
ALTER TABLE `api_logs` ADD INDEX IF NOT EXISTS `idx_request_time` (`request_time`);
ALTER TABLE `api_logs` ADD INDEX IF NOT EXISTS `idx_status` (`status`);

SELECT 'Database indexes optimization complete!' as Status;
