-- Fix search_logs table and create ration_card_data table

-- First, check if search_type column exists, if not add it
ALTER TABLE `search_logs` 
ADD COLUMN IF NOT EXISTS `search_type` VARCHAR(20) DEFAULT 'mobile' AFTER `search_query`;

-- Update to ENUM if column exists
ALTER TABLE `search_logs` 
MODIFY COLUMN `search_type` ENUM('mobile', 'ration_card') DEFAULT 'mobile';

-- Create ration_card_data table
CREATE TABLE IF NOT EXISTS `ration_card_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aadhaar_number` varchar(12) NOT NULL,
  `data` longtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `aadhaar_number` (`aadhaar_number`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

SELECT 'Ration Card setup completed successfully!' as Status;
