<?php
require_once __DIR__ . '/../includes/auth.php';

requireUser();

$user = getCurrentUser();
$permissions = getUserNavPermissions();

// Get referral statistics
$conn = getDBConnection();
$userId = (int) $_SESSION['user_id'];

// Get total referrals
$refCountSql = "SELECT COUNT(*) as total FROM referrals WHERE referrer_id = $userId";
$refCountResult = $conn->query($refCountSql);
$totalReferrals = 0;
if ($refCountResult && $refCountResult->num_rows > 0) {
    $totalReferrals = (int) $refCountResult->fetch_assoc()['total'];
}

// Get referral settings
$refSettingSql = "SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('referral_enabled', 'referrer_reward')";
$refSettingResult = $conn->query($refSettingSql);
$referralEnabled = false;
$referrerReward = 10;
if ($refSettingResult) {
    while ($row = $refSettingResult->fetch_assoc()) {
        if ($row['setting_key'] == 'referral_enabled') {
            $referralEnabled = (int) $row['setting_value'] === 1;
        } elseif ($row['setting_key'] == 'referrer_reward') {
            $referrerReward = (int) $row['setting_value'];
        }
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#FFFFFF">
    <title>Profile - Gravity</title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/user.css">
</head>

<body>
    <div class="user-container">
        <header class="app-header">
            <div class="welcome-section">
                <span class="welcome-label">Manage Account</span>
                <h1 class="welcome-name">Profile</h1>
            </div>
            <div id="logoutBtn" onclick="location.href='/app/api/logout.php'" class="profile-thumb"
                style="background: rgba(255, 59, 48, 0.1); color: #FF3B30; border-color: rgba(255, 59, 48, 0.2);">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                    stroke-linecap="round" stroke-linejoin="round">
                    <path d="M9 21H5a2 2 0 01-2-2V5a2 2 0 012-2h4m7 14l5-5-5-5m5 5H9"></path>
                </svg>
            </div>
        </header>

        <main class="app-main" style="position: relative; z-index: 1;">
            <!-- Profile Info Card -->
            <div class="profile-card"
                style="background: var(--bg-primary); padding: 24px; border-radius: 24px; margin-bottom: 24px; border: 1px solid var(--separator-color); text-align: center; box-shadow: var(--shadow-sm);">
                <div class="profile-avatar"
                    style="width: 80px; height: 80px; background: linear-gradient(135deg, var(--primary-color), #2196F3); color: white; border-radius: 28px; display: flex; align-items: center; justify-content: center; font-size: 32px; font-weight: 800; margin: 0 auto 16px; box-shadow: 0 10px 20px rgba(0, 122, 255, 0.2);">
                    <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
                </div>
                <h2 style="font-size: 22px; font-weight: 800; margin-bottom: 4px;">
                    <?php echo htmlspecialchars($user['name']); ?>
                </h2>
                <p style="color: var(--text-tertiary); font-size: 14px; font-weight: 500;">
                    <?php echo htmlspecialchars($user['email']); ?>
                </p>
            </div>

            <!-- Account Details -->
            <div class="section">
                <h3 class="section-title">Account Details</h3>

                <div class="activity-item"
                    style="padding: 16px 20px; border-radius: 20px; border: 1px solid var(--separator-color); margin-bottom: 12px;">
                    <div class="activity-content">
                        <span
                            style="font-size: 11px; font-weight: 700; color: var(--text-tertiary); text-transform: uppercase; letter-spacing: 0.5px;">Email
                            Address</span>
                        <div style="font-size: 16px; font-weight: 700; color: var(--text-primary); margin-top: 2px;">
                            <?php echo htmlspecialchars($user['email']); ?>
                        </div>
                    </div>
                </div>

                <div class="activity-item"
                    style="padding: 16px 20px; border-radius: 20px; border: 1px solid var(--separator-color); margin-bottom: 12px;">
                    <div class="activity-content">
                        <span
                            style="font-size: 11px; font-weight: 700; color: var(--text-tertiary); text-transform: uppercase; letter-spacing: 0.5px;">Mobile
                            Number</span>
                        <div style="font-size: 16px; font-weight: 700; color: var(--text-primary); margin-top: 2px;">
                            <?php echo htmlspecialchars($user['mobile']); ?>
                        </div>
                    </div>
                </div>

                <div class="activity-item"
                    style="padding: 16px 20px; border-radius: 20px; border: 1px solid var(--separator-color); margin-bottom: 12px;">
                    <div class="activity-content">
                        <span
                            style="font-size: 11px; font-weight: 700; color: var(--text-tertiary); text-transform: uppercase; letter-spacing: 0.5px;">Daily
                            Search Limit</span>
                        <div style="font-size: 16px; font-weight: 700; color: var(--text-primary); margin-top: 2px;">
                            <?php echo $user['daily_limit']; ?> Searches
                        </div>
                    </div>
                </div>

                <div class="activity-item"
                    style="padding: 16px 20px; border-radius: 20px; border: 1px solid var(--separator-color); margin-bottom: 12px;">
                    <div class="activity-content">
                        <span
                            style="font-size: 11px; font-weight: 700; color: var(--text-tertiary); text-transform: uppercase; letter-spacing: 0.5px;">Member
                            Since</span>
                        <div style="font-size: 16px; font-weight: 700; color: var(--text-primary); margin-top: 2px;">
                            <?php echo date('F d, Y', strtotime($user['created_at'])); ?>
                        </div>
                    </div>
                </div>

                <div class="activity-item"
                    style="padding: 16px 20px; border-radius: 20px; border: 1px solid var(--separator-color); margin-bottom: 12px;">
                    <div class="activity-content">
                        <span
                            style="font-size: 11px; font-weight: 700; color: var(--text-tertiary); text-transform: uppercase; letter-spacing: 0.5px;">Last
                            Login</span>
                        <div style="font-size: 16px; font-weight: 700; color: var(--text-primary); margin-top: 2px;">
                            <?php
                            if ($user['last_login']) {
                                echo date('F d, Y h:i A', strtotime($user['last_login']));
                            } else {
                                echo 'First time login';
                            }
                            ?>
                        </div>
                    </div>
                </div>

                <div class="activity-item"
                    style="padding: 16px 20px; border-radius: 20px; border: 1px solid var(--separator-color); margin-bottom: 12px;">
                    <div class="activity-content">
                        <span
                            style="font-size: 11px; font-weight: 700; color: var(--text-tertiary); text-transform: uppercase; letter-spacing: 0.5px;">Account
                            Status</span>
                        <div style="margin-top: 6px;">
                            <span class="badge badge-db"
                                style="font-size: 10px;"><?php echo strtoupper($user['status']); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <?php if ($referralEnabled): ?>
                <!-- Referral Section -->
                <div class="section" style="margin-top: 24px;">
                    <h3 class="section-title">🎁 Refer & Earn</h3>

                    <!-- Referral ID Card -->
                    <div
                        style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 24px; border-radius: 20px; margin-bottom: 16px; box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);">
                        <div style="color: white; font-size: 13px; font-weight: 600; margin-bottom: 8px; opacity: 0.9;">Your
                            Referral ID</div>
                        <div
                            style="display: flex; align-items: center; gap: 12px; background: rgba(255,255,255,0.2); padding: 14px 16px; border-radius: 12px; backdrop-filter: blur(10px);">
                            <input type="text" id="referralCodeDisplay"
                                value="<?php echo htmlspecialchars($user['referral_code']); ?>" readonly
                                style="flex: 1; background: transparent; border: none; color: white; font-size: 20px; font-weight: 800; letter-spacing: 2px; outline: none;">
                            <button onclick="copyReferralCode()"
                                style="background: rgba(255,255,255,0.3); border: none; padding: 10px 16px; border-radius: 8px; color: white; font-weight: 700; cursor: pointer; transition: all 0.2s; font-size: 13px;">
                                📋 Copy
                            </button>
                        </div>
                        <div style="color: rgba(255,255,255,0.9); font-size: 12px; margin-top: 12px; text-align: center;">
                            Share this ID with friends to earn rewards
                        </div>
                    </div>

                    <!-- Stats Grid -->
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 12px; margin-bottom: 16px;">
                        <div onclick="showReferralsList()"
                            style="background: var(--bg-primary); padding: 16px; border-radius: 16px; border: 1px solid var(--separator-color); text-align: center; cursor: pointer; transition: all 0.2s;"
                            onmouseover="this.style.transform='scale(1.05)'" onmouseout="this.style.transform='scale(1)'">
                            <div
                                style="font-size: 24px; font-weight: 800; color: var(--primary-color); margin-bottom: 4px;">
                                <?php echo $totalReferrals; ?>
                            </div>
                            <div style="font-size: 12px; color: var(--text-tertiary); font-weight: 600;">Total Referrals
                            </div>
                            <div style="font-size: 10px; color: var(--text-tertiary); margin-top: 4px;">👆 Tap to view</div>
                        </div>
                        <div
                            style="background: var(--bg-primary); padding: 16px; border-radius: 16px; border: 1px solid var(--separator-color); text-align: center;">
                            <div style="font-size: 24px; font-weight: 800; color: #34C759; margin-bottom: 4px;">
                                +<?php echo $user['referral_bonus']; ?></div>
                            <div style="font-size: 12px; color: var(--text-tertiary); font-weight: 600;">Bonus Searches
                            </div>
                        </div>
                    </div>

                    <!-- How it Works -->
                    <div
                        style="background: var(--bg-primary); padding: 20px; border-radius: 16px; border: 1px solid var(--separator-color); margin-bottom: 16px;">
                        <div style="font-size: 14px; font-weight: 700; color: var(--text-primary); margin-bottom: 12px;">📝
                            How it Works:</div>
                        <div style="font-size: 13px; color: var(--text-secondary); line-height: 1.8;">
                            1️⃣ Share your Referral ID with friends<br>
                            2️⃣ They enter your ID during registration<br>
                            3️⃣ You get <strong style="color: #34C759;">+<?php echo $referrerReward; ?>
                                searches</strong><br>
                            4️⃣ They get <strong style="color: #34C759;">20 searches</strong> (instead of 10)
                        </div>
                    </div>

                    <!-- Reward Info -->
                    <div
                        style="background: rgba(52, 199, 89, 0.1); padding: 14px 16px; border-radius: 12px; border: 1px solid rgba(52, 199, 89, 0.2);">
                        <div
                            style="font-size: 13px; color: #34C759; font-weight: 600; line-height: 1.6; text-align: center;">
                            💰 Earn +<?php echo $referrerReward; ?> searches for each friend who uses your ID!
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Referrals List Modal -->
            <div id="referralsModal"
                style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.6); z-index: 1000; align-items: center; justify-content: center; padding: 20px;">
                <div onclick="event.stopPropagation()"
                    style="background: var(--bg-primary); border-radius: 20px; max-width: 500px; width: 100%; max-height: 80vh; overflow: hidden; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
                    <!-- Modal Header -->
                    <div
                        style="padding: 20px 24px; border-bottom: 1px solid var(--separator-color); display: flex; justify-content: space-between; align-items: center;">
                        <h3 style="margin: 0; font-size: 18px; font-weight: 700; color: var(--text-primary);">👥 My
                            Referrals</h3>
                        <button onclick="closeReferralsModal()"
                            style="background: none; border: none; font-size: 24px; color: var(--text-secondary); cursor: pointer; padding: 0; width: 32px; height: 32px; display: flex; align-items: center; justify-content: center; border-radius: 8px; transition: background 0.2s;">
                            ×
                        </button>
                    </div>

                    <!-- Modal Body -->
                    <div id="referralsContent"
                        style="padding: 20px 24px; overflow-y: auto; max-height: calc(80vh - 80px);">
                        <div style="text-align: center; padding: 40px 20px; color: var(--text-tertiary);">
                            <div style="font-size: 48px; margin-bottom: 16px;">⏳</div>
                            <div>Loading referrals...</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Change Password -->
            <div class="section" style="margin-top: 24px;">
                <h3 class="section-title">Change Password</h3>
                <form id="passwordForm"
                    style="background: var(--bg-primary); padding: 20px; border-radius: 20px; border: 1px solid var(--separator-color);">
                    <div class="form-group" style="margin-bottom: 16px;">
                        <label
                            style="font-size: 12px; font-weight: 600; color: var(--text-secondary); margin-bottom: 8px; display: block;">Current
                            Password</label>
                        <div style="position: relative;">
                            <input type="password" id="currentPassword" required
                                style="width: 100%; padding: 12px 40px 12px 14px; border: 1px solid var(--border-color); border-radius: 12px; font-size: 15px;">
                            <button type="button" onclick="togglePasswordProfile('currentPassword', 'eyeIconCurrent')"
                                style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 8px; color: var(--text-tertiary);">
                                <svg id="eyeIconCurrent" width="18" height="18" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2">
                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                    <circle cx="12" cy="12" r="3"></circle>
                                </svg>
                            </button>
                        </div>
                    </div>
                    <div class="form-group" style="margin-bottom: 16px;">
                        <label
                            style="font-size: 12px; font-weight: 600; color: var(--text-secondary); margin-bottom: 8px; display: block;">New
                            Password</label>
                        <div style="position: relative;">
                            <input type="password" id="newPassword" required minlength="6"
                                style="width: 100%; padding: 12px 40px 12px 14px; border: 1px solid var(--border-color); border-radius: 12px; font-size: 15px;">
                            <button type="button" onclick="togglePasswordProfile('newPassword', 'eyeIconNew')"
                                style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 8px; color: var(--text-tertiary);">
                                <svg id="eyeIconNew" width="18" height="18" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2">
                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                    <circle cx="12" cy="12" r="3"></circle>
                                </svg>
                            </button>
                        </div>
                    </div>
                    <div class="form-group" style="margin-bottom: 20px;">
                        <label
                            style="font-size: 12px; font-weight: 600; color: var(--text-secondary); margin-bottom: 8px; display: block;">Confirm
                            New Password</label>
                        <div style="position: relative;">
                            <input type="password" id="confirmPassword" required minlength="6"
                                style="width: 100%; padding: 12px 40px 12px 14px; border: 1px solid var(--border-color); border-radius: 12px; font-size: 15px;">
                            <button type="button" onclick="togglePasswordProfile('confirmPassword', 'eyeIconConfirm')"
                                style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 8px; color: var(--text-tertiary);">
                                <svg id="eyeIconConfirm" width="18" height="18" viewBox="0 0 24 24" fill="none"
                                    stroke="currentColor" stroke-width="2">
                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                                    <circle cx="12" cy="12" r="3"></circle>
                                </svg>
                            </button>
                        </div>
                    </div>
                    <button type="submit" class="btn-search-app"
                        style="width: 100%; background: var(--primary-color); color: white; border-color: var(--primary-color);">Update
                        Password</button>
                </form>
            </div>

            <!-- About App -->

            <!-- Logout -->
            <div class="section" style="margin-top: 16px;">
                <button onclick="location.href='/app/api/logout.php'" class="btn-search-app"
                    style="background: rgba(255, 59, 48, 0.05); border-color: rgba(255, 59, 48, 0.1); color: #FF3B30; width: 100%;">
                    Log Out of Account
                </button>
            </div>
        </main>

        <?php include __DIR__ . '/../includes/user-nav.php'; ?>
    </div>

    <div id="toast" class="toast"></div>

    <script>
        document.getElementById('passwordForm').addEventListener('submit', async (e) => {
            e.preventDefault();

            const currentPassword = document.getElementById('currentPassword').value;
            const newPassword = document.getElementById('newPassword').value;
            const confirmPassword = document.getElementById('confirmPassword').value;

            if (newPassword !== confirmPassword) {
                showToast('Passwords do not match', 'error');
                return;
            }

            if (newPassword.length < 6) {
                showToast('Password must be at least 6 characters', 'error');
                return;
            }

            try {
                const response = await fetch('/app/api/update-password.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ currentPassword, newPassword })
                });

                const data = await response.json();

                if (data.success) {
                    showToast('Password updated successfully', 'success');
                    document.getElementById('passwordForm').reset();
                } else {
                    showToast(data.message || 'Failed to update password', 'error');
                }
            } catch (error) {
                showToast('Network error. Please try again.', 'error');
            }
        });

        function showToast(message, type = 'info') {
            const toast = document.getElementById('toast');
            toast.textContent = message;
            toast.className = `toast toast-${type} show`;
            setTimeout(() => toast.classList.remove('show'), 3000);
        }

        // Toggle password visibility
        function togglePasswordProfile(inputId, iconId) {
            const passwordInput = document.getElementById(inputId);
            const eyeIcon = document.getElementById(iconId);

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.innerHTML = '<path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"></path><line x1="1" y1="1" x2="23" y2="23"></line>';
            } else {
                passwordInput.type = 'password';
                eyeIcon.innerHTML = '<path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle>';
            }
        }

        // Copy referral code
        function copyReferralCode() {
            const codeInput = document.getElementById('referralCodeDisplay');
            codeInput.select();
            document.execCommand('copy');
            showToast('Referral ID copied!', 'success');
        }

        // Show referrals list modal
        async function showReferralsList() {
            const modal = document.getElementById('referralsModal');
            modal.style.display = 'flex';
            document.body.style.overflow = 'hidden';

            // Fetch referrals
            try {
                const response = await fetch('/app/api/user/get-referrals.php');
                const data = await response.json();

                const content = document.getElementById('referralsContent');

                if (data.success && data.referrals.length > 0) {
                    let html = '<div style="margin-bottom: 16px; padding: 12px 16px; background: var(--bg-secondary); border-radius: 12px; text-align: center;">';
                    html += `<div style="font-size: 14px; font-weight: 700; color: var(--text-primary);">Total: ${data.total} Referrals</div>`;
                    html += '</div>';

                    data.referrals.forEach((ref, index) => {
                        html += `
                            <div style="background: var(--bg-secondary); padding: 16px; border-radius: 12px; margin-bottom: 12px; border: 1px solid var(--separator-color);">
                                <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 8px;">
                                    <div style="flex: 1;">
                                        <div style="font-size: 15px; font-weight: 700; color: var(--text-primary); margin-bottom: 4px;">
                                            ${index + 1}. ${ref.name}
                                        </div>
                                        <div style="font-size: 12px; color: var(--text-tertiary);">
                                            ${ref.email}
                                        </div>
                                    </div>
                                    <div style="text-align: right;">
                                        <div style="font-size: 18px; font-weight: 800; color: #34C759;">
                                            ${ref.total_searches}
                                        </div>
                                        <div style="font-size: 10px; color: var(--text-tertiary);">
                                            searches
                                        </div>
                                    </div>
                                </div>
                                <div style="display: flex; justify-content: space-between; align-items: center; padding-top: 8px; border-top: 1px solid var(--separator-color);">
                                    <div style="font-size: 11px; color: var(--text-tertiary);">
                                        📅 Joined: ${ref.joined_date}
                                    </div>
                                    <div style="font-size: 11px; color: #34C759; font-weight: 600;">
                                        +${ref.reward_earned} bonus
                                    </div>
                                </div>
                            </div>
                        `;
                    });

                    content.innerHTML = html;
                } else {
                    content.innerHTML = `
                        <div style="text-align: center; padding: 40px 20px; color: var(--text-tertiary);">
                            <div style="font-size: 64px; margin-bottom: 16px;">👥</div>
                            <div style="font-size: 16px; font-weight: 600; margin-bottom: 8px;">No Referrals Yet</div>
                            <div style="font-size: 13px;">Share your referral ID to start earning!</div>
                        </div>
                    `;
                }
            } catch (error) {
                document.getElementById('referralsContent').innerHTML = `
                    <div style="text-align: center; padding: 40px 20px; color: var(--text-tertiary);">
                        <div style="font-size: 48px; margin-bottom: 16px;">❌</div>
                        <div>Failed to load referrals</div>
                    </div>
                `;
            }
        }

        // Close referrals modal
        function closeReferralsModal() {
            const modal = document.getElementById('referralsModal');
            modal.style.display = 'none';
            document.body.style.overflow = 'auto';
        }

        // Close modal on outside click
        document.getElementById('referralsModal')?.addEventListener('click', function (e) {
            if (e.target === this) {
                closeReferralsModal();
            }
        });
    </script>
</body>

</html>