<?php
require_once __DIR__ . '/../includes/auth.php';

requireUser();

$user = getCurrentUser();
$permissions = getUserNavPermissions();

// Get app settings from database
$conn = getDBConnection();
$sql = "SELECT * FROM settings";
$result = $conn->query($sql);
$settings = [];
while ($row = $result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
$conn->close();


$appName = $settings['app_name'] ?? 'Mobile Search Pro';
$appVersion = $settings['app_version'] ?? '1.0.0';
$buildingId = $settings['building_id'] ?? '20251220';
$privacyText = $settings['privacy_policy_text'] ?? '';
$termsText = $settings['terms_of_service_text'] ?? '';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="theme-color" content="#FFFFFF">
    <title>Support - <?php echo htmlspecialchars($appName); ?></title>
    <link rel="stylesheet" href="/app/assets/css/style.css">
    <link rel="stylesheet" href="/app/assets/css/user.css">
    <style>
        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.6);
            z-index: 1000;
            animation: fadeIn 0.3s ease;
        }

        .modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .modal-content {
            background: var(--bg-primary);
            border-radius: 16px;
            max-width: 600px;
            width: 100%;
            max-height: 80vh;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
            animation: slideUp 0.3s ease;
        }

        .modal-header {
            padding: 20px 24px;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .modal-title {
            font-size: 20px;
            font-weight: 600;
            color: var(--text-primary);
            margin: 0;
        }

        .modal-close {
            background: none;
            border: none;
            font-size: 24px;
            color: var(--text-secondary);
            cursor: pointer;
            padding: 0;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            transition: background 0.2s;
        }

        .modal-close:hover {
            background: var(--bg-secondary);
        }

        .modal-body {
            padding: 24px;
            overflow-y: auto;
            max-height: calc(80vh - 80px);
            color: var(--text-secondary);
            line-height: 1.8;
            white-space: normal;
            word-wrap: break-word;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes slideUp {
            from {
                transform: translateY(30px);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
    </style>
</head>

<body>
    <div class="user-container">
        <header class="app-header">
            <div class="welcome-section">
                <span class="welcome-label">Help & Information</span>
                <h1 class="welcome-name">Support</h1>
            </div>
            <div class="profile-thumb">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                    stroke-linecap="round" stroke-linejoin="round">
                    <circle cx="12" cy="12" r="10"></circle>
                    <path d="M9.09 9a3 3 0 015.83 1c0 2-3 3-3 3m0 5h.01"></path>
                </svg>
            </div>
        </header>

        <main class="app-main" style="position: relative; z-index: 1;">
            <!-- How it works card -->
            <div class="section">
                <div class="stats-card"
                    style="background: linear-gradient(135deg, #1C1C1E, #2C2C2E); box-shadow: 0 10px 30px rgba(0,0,0,0.15);">
                    <h3 class="stats-title" style="margin-bottom: 12px; opacity: 1;">How It Works</h3>
                    <p style="font-size: 14px; line-height: 1.6; opacity: 0.9;">
                        Enter any 10-digit mobile number to search for information.
                        We check our local database first to provide instant results.
                        If not found, we fetch the latest data from our secure external API.
                    </p>
                </div>
            </div>

            <!-- FAQ/Features List -->
            <div class="section">
                <h3 class="section-title">Key Features</h3>

                <div class="activity-item">
                    <div class="activity-icon" style="background: rgba(0, 122, 255, 0.1);">
                        <span style="font-size: 20px;">⚡</span>
                    </div>
                    <div class="activity-content">
                        <div class="activity-title">Instant Lookup</div>
                        <div class="activity-meta">Real-time mobile number search</div>
                    </div>
                </div>

                <div class="activity-item">
                    <div class="activity-icon" style="background: rgba(52, 199, 89, 0.1);">
                        <span style="font-size: 20px;">🛡️</span>
                    </div>
                    <div class="activity-content">
                        <div class="activity-title">Privacy First</div>
                        <div class="activity-meta">Secure and safe data handling</div>
                    </div>
                </div>

                <div class="activity-item">
                    <div class="activity-icon" style="background: rgba(255, 149, 0, 0.1);">
                        <span style="font-size: 20px;">😂</span>
                    </div>
                    <div class="activity-content">
                        <div class="activity-title">App be like</div>
                        <strong>
                            <div class="activity-meta">HACK ಮಾಡ್ತೀನಿ CRASH ಮಾಡ್ತೀನಿ ಬೇಡ BRO ನಿಮ್ಮ ಹುಡುಕೋದು ನನಗೆ
                                ದೊಡ್ದುದಲ್ಲ
                            </div>
                        </strong>
                    </div>
                </div>
            </div>

            <!-- About App Button -->


            <!-- App info footer -->
            <div class="section" style="text-align: center; padding: 40px 20px; color: var(--text-tertiary);">
                <div style="font-size: 18px; font-weight: 800; color: var(--text-primary); margin-bottom: 8px;">
                    <?php echo htmlspecialchars($appName); ?>
                </div>
                <div style="font-size: 13px; font-weight: 500; margin-bottom: 24px;">
                    Version <?php echo htmlspecialchars($appVersion); ?> (Building ID:
                    <?php echo htmlspecialchars($buildingId); ?>)
                </div>

                <!-- Privacy Policy Modal -->
                <?php if ($privacyText): ?>
                    <div id="privacyModal" class="modal" onclick="closeModal(event, 'privacy')">
                        <div class="modal-content" onclick="event.stopPropagation()">
                            <div class="modal-header">
                                <h2 class="modal-title">Privacy Policy</h2>
                                <button class="modal-close" onclick="closeModal(event, 'privacy')">&times;</button>
                            </div>
                            <div class="modal-body">
                                <?php echo htmlspecialchars($privacyText); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Terms of Service Modal -->
                <?php if ($termsText): ?>
                    <div id="termsModal" class="modal" onclick="closeModal(event, 'terms')">
                        <div class="modal-content" onclick="event.stopPropagation()">
                            <div class="modal-header">
                                <h2 class="modal-title">Terms of Service</h2>
                                <button class="modal-close" onclick="closeModal(event, 'terms')">&times;</button>
                            </div>
                            <div class="modal-body">
                                <?php echo htmlspecialchars($termsText); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Links Section -->
                <?php if ($privacyText || $termsText): ?>
                    <div style="display: flex; justify-content: center; gap: 20px; margin-top: 24px;">
                        <?php if ($privacyText): ?>
                            <a onclick="showModal('privacy')"
                                style="color: var(--primary-color); text-decoration: none; font-size: 13px; font-weight: 700; cursor: pointer;">Privacy
                                Policy</a>
                        <?php endif; ?>

                        <?php if ($privacyText && $termsText): ?>
                            <span style="opacity: 0.3;">|</span>
                        <?php endif; ?>

                        <?php if ($termsText): ?>
                            <a onclick="showModal('terms')"
                                style="color: var(--primary-color); text-decoration: none; font-size: 13px; font-weight: 700; cursor: pointer;">Terms
                                of Service</a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </main>

        <?php include __DIR__ . '/../includes/user-nav.php'; ?>
    </div>

    <script>
        function showModal(type) {
            const modal = document.getElementById(type === 'privacy' ? 'privacyModal' : 'termsModal');
            if (modal) {
                modal.classList.add('show');
                document.body.style.overflow = 'hidden';
            }
        }

        function closeModal(event, type) {
            event.stopPropagation();
            const modal = document.getElementById(type === 'privacy' ? 'privacyModal' : 'termsModal');
            if (modal) {
                modal.classList.remove('show');
                document.body.style.overflow = '';
            }
        }

        // Close modal on Escape key
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') {
                document.querySelectorAll('.modal.show').forEach(modal => {
                    modal.classList.remove('show');
                    document.body.style.overflow = '';
                });
            }
        });
    </script>
</body>

</html>