<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aadhaar Search - Final</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <div class="mobile-container" style="padding: 20px; padding-bottom: 100px;">
        <div style="text-align: center; margin-bottom: 30px;">
            <h1 style="font-size: 28px; margin-bottom: 10px; color: #FF9500;">🔍 Aadhaar Search</h1>
            <p style="color: #8E8E93;">Enter 12-digit Aadhaar number</p>
        </div>

        <div
            style="background: white; padding: 20px; border-radius: 16px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); margin-bottom: 20px;">
            <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #1C1C1E;">Aadhaar Number</label>
            <input type="tel" id="aadhaar" placeholder="Enter 12-digit Aadhaar" maxlength="12"
                style="width: 100%; padding: 16px; border: 2px solid #E5E5EA; border-radius: 12px; font-size: 18px; margin-bottom: 16px; box-sizing: border-box;">

            <button id="searchBtn" onclick="search()"
                style="width: 100%; padding: 16px; background: linear-gradient(135deg, #FF9500 0%, #FF5E3A 100%); color: white; border: none; border-radius: 12px; font-size: 18px; font-weight: 600; cursor: pointer;">
                Search Aadhaar
            </button>
        </div>

        <div id="result" style="display: none;"></div>

        <div style="padding: 15px; background: #f5f5f7; border-radius: 12px;">
            <strong style="display: block; margin-bottom: 10px;">📋 Test Numbers:</strong>
            <button onclick="fill('931894246237')"
                style="width: 100%; padding: 10px; background: white; border: 1px solid #E5E5EA; border-radius: 8px; cursor: pointer; margin-bottom: 8px;">931894246237</button>
            <button onclick="fill('808262365427')"
                style="width: 100%; padding: 10px; background: white; border: 1px solid #E5E5EA; border-radius: 8px; cursor: pointer; margin-bottom: 8px;">808262365427</button>
            <button onclick="fill('701728922808')"
                style="width: 100%; padding: 10px; background: white; border: 1px solid #E5E5EA; border-radius: 8px; cursor: pointer;">701728922808</button>
        </div>
    </div>

    <?php include 'navbar.php'; ?>

    <script src="script.js"></script>
    <script>
        function fill(num) {
            document.getElementById('aadhaar').value = num;
        }

        async function search() {
            const input = document.getElementById('aadhaar');
            const btn = document.getElementById('searchBtn');
            const result = document.getElementById('result');

            const aadhaar = input.value.trim();

            if (!aadhaar || aadhaar.length !== 12) {
                if (typeof showToast === 'function') {
                    showToast('Please enter 12-digit Aadhaar', 'error');
                } else {
                    alert('Please enter 12-digit Aadhaar');
                }
                return;
            }

            btn.disabled = true;
            btn.textContent = '🔄 Searching...';
            result.style.display = 'block';
            result.innerHTML = '<p style="text-align: center; padding: 20px;">⏳ Searching...</p>';

            try {
                const response = await fetch('api/aadhaar_search.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'aadhaar=' + aadhaar
                });

                const data = await response.json();

                if (data.success && data.data) {
                    let html = `
                        <div style="background: white; padding: 20px; border-radius: 16px; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
                            <div style="text-align: center; margin-bottom: 20px;">
                                <div style="width: 80px; height: 80px; margin: 0 auto 12px; border-radius: 50%; background: linear-gradient(135deg, #FF9500 0%, #FF5E3A 100%); display: flex; align-items: center; justify-content: center; font-size: 32px; color: white;">👤</div>
                                <h3 style="margin: 0; font-size: 20px; font-weight: 700;">${data.data.name}</h3>
                                <p style="margin: 4px 0 0; color: #8E8E93; font-size: 14px;">Ration Card Holder</p>
                            </div>
                            <div style="background: #f5f5f7; padding: 15px; border-radius: 12px; margin-bottom: 15px;">
                                <p style="margin: 5px 0; font-size: 14px;"><strong>📍 Address:</strong> ${data.data.address}</p>
                                <p style="margin: 5px 0; font-size: 14px;"><strong>🏙️ District:</strong> ${data.data.district}</p>
                                <p style="margin: 5px 0; font-size: 14px;"><strong>🗺️ State:</strong> ${data.data.state}</p>
                                <p style="margin: 5px 0; font-size: 14px;"><strong>🆔 RC ID:</strong> ${data.data.rcId}</p>
                                <p style="margin: 5px 0; font-size: 14px;"><strong>🏪 FPS ID:</strong> ${data.data.fpsId}</p>
                                <p style="margin: 5px 0; font-size: 14px;"><strong>📋 Scheme:</strong> ${data.data.scheme}</p>
                            </div>
                    `;

                    if (data.data.familyMembers && data.data.familyMembers.length > 0) {
                        html += `<h4 style="margin: 15px 0 10px; font-size: 16px;">👨‍👩‍👧‍👦 Family Members (${data.data.totalMembers})</h4>`;
                        data.data.familyMembers.forEach(member => {
                            html += `
                                <div style="padding: 12px; background: #f5f5f7; border-radius: 8px; margin-bottom: 8px;">
                                    <div style="font-weight: 600; margin-bottom: 4px;">${member.memberName}</div>
                                    <div style="font-size: 13px; color: #8E8E93;">${member.releationship_name} ${member.uid === 'Yes' ? '✓ UID' : '✗ No UID'}</div>
                                </div>
                            `;
                        });
                    }

                    html += '</div>';
                    result.innerHTML = html;

                    if (typeof showToast === 'function') {
                        showToast('Data found!', 'success');
                    }
                } else {
                    result.innerHTML = `<div style="padding: 20px; background: #f8d7da; border-radius: 12px; color: #721c24;">❌ ${data.error || 'No data found'}</div>`;
                }
            } catch (error) {
                result.innerHTML = `<div style="padding: 20px; background: #f8d7da; border-radius: 12px; color: #721c24;">❌ Error: ${error.message}</div>`;
            }

            btn.disabled = false;
            btn.textContent = 'Search Aadhaar';
        }
    </script>
</body>

</html>