<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aadhaar Search - Simple Test</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <div class="mobile-container" style="padding: 20px;">
        <h2 style="text-align: center; margin-bottom: 20px;">🔍 Aadhaar Search Test</h2>

        <div style="background: white; padding: 20px; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
            <input type="tel" id="aadhaarInput" placeholder="Enter 12-digit Aadhaar" maxlength="12"
                style="width: 100%; padding: 12px; border: 2px solid #E5E5EA; border-radius: 8px; font-size: 16px; margin-bottom: 12px;">

            <button onclick="searchAadhaar()"
                style="width: 100%; padding: 14px; background: linear-gradient(135deg, #FF9500 0%, #FF5E3A 100%); color: white; border: none; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer;">
                🔍 Search Aadhaar
            </button>

            <div id="result" style="margin-top: 20px; display: none;"></div>
        </div>

        <div style="margin-top: 20px; padding: 15px; background: #f5f5f7; border-radius: 8px;">
            <strong>Test Numbers:</strong><br>
            <button onclick="document.getElementById('aadhaarInput').value='931894246237'"
                style="margin: 5px; padding: 8px 12px; background: #007AFF; color: white; border: none; border-radius: 6px; cursor: pointer;">931894246237</button>
            <button onclick="document.getElementById('aadhaarInput').value='808262365427'"
                style="margin: 5px; padding: 8px 12px; background: #007AFF; color: white; border: none; border-radius: 6px; cursor: pointer;">808262365427</button>
            <button onclick="document.getElementById('aadhaarInput').value='701728922808'"
                style="margin: 5px; padding: 8px 12px; background: #007AFF; color: white; border: none; border-radius: 6px; cursor: pointer;">701728922808</button>
        </div>
    </div>

    <script src="script.js"></script>
    <script>
        async function searchAadhaar() {
            const aadhaar = document.getElementById('aadhaarInput').value.trim();
            const resultDiv = document.getElementById('result');

            if (!aadhaar || aadhaar.length !== 12) {
                alert('Please enter a valid 12-digit Aadhaar number');
                return;
            }

            resultDiv.innerHTML = '<p style="text-align: center;">⏳ Searching...</p>';
            resultDiv.style.display = 'block';

            try {
                const response = await fetch('api/aadhaar_search.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'aadhaar=' + encodeURIComponent(aadhaar)
                });

                const data = await response.json();

                if (data.success && data.data) {
                    let familyHTML = '';
                    if (data.data.familyMembers && data.data.familyMembers.length > 0) {
                        familyHTML = '<h4 style="margin-top: 20px;">👨‍👩‍👧‍👦 Family Members (' + data.data.totalMembers + ')</h4>';
                        data.data.familyMembers.forEach(member => {
                            familyHTML += `
                                <div style="padding: 10px; background: #f5f5f7; border-radius: 8px; margin-bottom: 8px;">
                                    <strong>${member.memberName}</strong><br>
                                    <small>${member.releationship_name} ${member.uid === 'Yes' ? '✓' : '✗'}</small>
                                </div>
                            `;
                        });
                    }

                    resultDiv.innerHTML = `
                        <div style="text-align: center; padding: 20px; background: #d4edda; border-radius: 8px;">
                            <h3 style="margin: 0 0 10px 0;">✅ ${data.data.name}</h3>
                            <p style="margin: 5px 0;"><strong>📍</strong> ${data.data.address}</p>
                            <p style="margin: 5px 0;"><strong>🏙️</strong> ${data.data.district}, ${data.data.state}</p>
                            <p style="margin: 5px 0;"><strong>🆔</strong> RC: ${data.data.rcId} | FPS: ${data.data.fpsId}</p>
                            <p style="margin: 5px 0;"><strong>📋</strong> ${data.data.scheme}</p>
                        </div>
                        ${familyHTML}
                    `;
                } else {
                    resultDiv.innerHTML = `
                        <div style="padding: 15px; background: #f8d7da; border-radius: 8px; color: #721c24;">
                            ❌ ${data.error || 'No data found'}
                        </div>
                    `;
                }
            } catch (error) {
                resultDiv.innerHTML = `
                    <div style="padding: 15px; background: #f8d7da; border-radius: 8px; color: #721c24;">
                        ❌ Error: ${error.message}
                    </div>
                `;
            }
        }
    </script>
</body>

</html>