<?php
session_start();
require_once '../db.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

$toast_success = isset($_SESSION['toast_success']) ? $_SESSION['toast_success'] : '';
$toast_error = isset($_SESSION['toast_error']) ? $_SESSION['toast_error'] : '';
unset($_SESSION['toast_success']);
unset($_SESSION['toast_error']);

// Handle create announcement
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['create'])) {
    $title = sanitize_input($_POST['title']);
    $message = sanitize_input($_POST['message']);

    $sql = "INSERT INTO announcements (title, content, status) 
            VALUES ('$title', '$message', 'active')";

    if (mysqli_query($conn, $sql)) {
        $_SESSION['toast_success'] = 'Announcement created successfully!';
        header('Location: announcements.php');
        exit();
    }
}

// Handle toggle active
if (isset($_GET['toggle'])) {
    $id = (int) $_GET['toggle'];
    $sql = "UPDATE announcements SET status = IF(status = 'active', 'inactive', 'active') WHERE id = $id";
    mysqli_query($conn, $sql);
    $_SESSION['toast_success'] = 'Announcement updated!';
    header('Location: announcements.php');
    exit();
}

// Handle delete
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    mysqli_query($conn, "DELETE FROM announcements WHERE id = $id");
    $_SESSION['toast_success'] = 'Announcement deleted!';
    header('Location: announcements.php');
    exit();
}

$announcements = mysqli_query($conn, "SELECT * FROM announcements ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Announcements - Admin</title>
    <link rel="stylesheet" href="../style.css">
</head>

<body>
    <div class="mobile-container" style="padding-bottom: 80px;">
        <div class="dashboard-wrapper">
            <div class="profile-header">
                <a href="dashboard.php" class="back-button">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 12H5M12 19l-7-7 7-7" />
                    </svg>
                </a>
                <h1 class="header-title">Announcements</h1>
                <div class="header-spacer"></div>
            </div>

            <!-- Create Form -->
            <div class="form-section">
                <h3 class="section-title">Create Announcement</h3>
                <form method="POST">
                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" name="title" required placeholder="Enter announcement title">
                    </div>
                    <div class="form-group">
                        <label>Message</label>
                        <textarea name="message" rows="3" required placeholder="Enter announcement message"
                            style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px; font-family: inherit; resize: vertical;"></textarea>
                    </div>
                    <div class="form-group">
                        <label>Type</label>
                        <select name="type"
                            style="width: 100%; padding: 12px; border: 1px solid var(--border-color); border-radius: 8px;">
                            <option value="info">ℹ️ Info (Blue)</option>
                            <option value="success">✅ Success (Green)</option>
                            <option value="warning">⚠️ Warning (Yellow)</option>
                            <option value="error">❌ Error (Red)</option>
                        </select>
                    </div>
                    <button type="submit" name="create" class="btn btn-primary">📢 Create Announcement</button>
                </form>
            </div>

            <!-- List -->
            <div class="form-section">
                <h3 class="section-title">All Announcements</h3>
                <?php if (mysqli_num_rows($announcements) > 0): ?>
                    <?php while ($ann = mysqli_fetch_assoc($announcements)): ?>
                        <div class="alert alert-info" style="margin-bottom: 12px; position: relative;">
                            <strong
                                style="display: block; margin-bottom: 4px;"><?php echo htmlspecialchars($ann['title']); ?></strong>
                            <p style="margin: 5px 0; font-size: 13px;"><?php echo htmlspecialchars($ann['content']); ?></p>
                            <small style="opacity: 0.7; font-size: 11px;">
                                <?php echo date('M d, Y h:i A', strtotime($ann['created_at'])); ?> •
                                Status: <strong><?php echo $ann['status'] == 'active' ? 'Active' : 'Inactive'; ?></strong>
                            </small>
                            <div style="display: flex; gap: 8px; margin-top: 10px;">
                                <a href="?toggle=<?php echo $ann['id']; ?>" class="btn"
                                    style="font-size: 12px; padding: 6px 12px; flex: 1; text-align: center;">
                                    <?php echo $ann['status'] == 'active' ? '🔴 Deactivate' : '🟢 Activate'; ?>
                                </a>
                                <a href="?delete=<?php echo $ann['id']; ?>" class="btn btn-danger"
                                    style="font-size: 12px; padding: 6px 12px; flex: 1; text-align: center;"
                                    onclick="return confirm('Delete this announcement?')">
                                    🗑️ Delete
                                </a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <p style="text-align: center; color: var(--text-secondary); padding: 20px;">No announcements yet. Create
                        one above!</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <div class="nav-icon-wrapper">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z" />
                </svg>
            </div>
            <span>Dashboard</span>
        </a>

        <a href="users.php" class="nav-item">
            <div class="nav-icon-wrapper">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                    <path
                        d="M17 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2M9 11a4 4 0 100-8 4 4 0 000 8zM23 21v-2a4 4 0 00-3-3.87M16 3.13a4 4 0 010 7.75" />
                </svg>
            </div>
            <span>Users</span>
        </a>

        <a href="announcements.php" class="nav-item active">
            <div class="nav-icon-wrapper">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M18 8A6 6 0 106 8c0 7-3 9-3 9h18s-3-2-3-9M13.73 21a2 2 0 01-3.46 0" />
                </svg>
            </div>
            <span>Announce</span>
        </a>

        <a href="profile.php" class="nav-item">
            <div class="nav-icon-wrapper">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M20 21v-2a4 4 0 00-4-4H8a4 4 0 00-4 4v2M12 11a4 4 0 100-8 4 4 0 000 8z" />
                </svg>
            </div>
            <span>Profile</span>
        </a>
    </nav>

    <script src="../script.js"></script>
    <script>
        <?php if ($toast_success): ?>
            showToast('<?php echo addslashes($toast_success); ?>', 'success');
        <?php endif; ?>

        <?php if ($toast_error): ?>
            showToast('<?php echo addslashes($toast_error); ?>', 'error');
        <?php endif; ?>
    </script>
</body>

</html>