<?php
session_start();
require_once '../db.php';

// Redirect if already logged in as admin
if (isset($_SESSION['admin_id'])) {
    header('Location: dashboard.php');
    exit();
}

$error = '';

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = sanitize_input($_POST['email']);
    $password = $_POST['password'];

    // Validation
    if (empty($email) || empty($password)) {
        $error = 'All fields are required';
    } else {
        // Query admin user
        $sql = "SELECT * FROM users WHERE email = '$email' AND role = 'admin' AND status = 'active'";
        $result = mysqli_query($conn, $sql);

        if (mysqli_num_rows($result) > 0) {
            $admin = mysqli_fetch_assoc($result);

            // Verify password
            if (password_verify($password, $admin['password'])) {
                // Login successful
                $_SESSION['admin_id'] = $admin['id'];
                $_SESSION['admin_name'] = $admin['name'];
                $_SESSION['admin_email'] = $admin['email'];

                // Log activity
                log_activity($admin['id'], 'admin_login', 'Admin Login', 'Admin logged in successfully');

                // Set success message
                $_SESSION['toast_success'] = 'Welcome back, Admin!';

                header('Location: dashboard.php');
                exit();
            } else {
                $error = 'Invalid credentials';
            }
        } else {
            $error = 'Invalid credentials';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <title>Admin Login - Mobile App</title>
    <link rel="stylesheet" href="../style.css">
</head>

<body>
    <div class="mobile-container">
        <div class="auth-wrapper">
            <!-- App Icon -->
            <div class="app-icon">
                <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="64" height="64" rx="16" fill="#FF3B30" />
                    <path
                        d="M32 20C25.37 20 20 25.37 20 32C20 38.63 25.37 44 32 44C38.63 44 44 38.63 44 32C44 25.37 38.63 20 32 20ZM32 26C34.21 26 36 27.79 36 30C36 32.21 34.21 34 32 34C29.79 34 28 32.21 28 30C28 27.79 29.79 26 32 26ZM32 42C28.67 42 25.8 40.34 24 37.84C24.04 35.29 29.33 33.9 32 33.9C34.66 33.9 39.96 35.29 40 37.84C38.2 40.34 35.33 42 32 42Z"
                        fill="white" />
                </svg>
            </div>

            <!-- Page Title -->
            <h1 class="page-title">Admin Panel</h1>
            <p class="page-subtitle">Sign in to continue</p>

            <!-- Alert Messages -->
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" />
                    </svg>
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <!-- Login Form -->
            <form method="POST" action="" class="auth-form" id="adminLoginForm">
                <div class="form-group">
                    <label for="email">Admin Email</label>
                    <input type="email" id="email" name="email" placeholder="admin@app.com" required
                        autocomplete="username">
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" placeholder="Enter your password" required
                        autocomplete="current-password">
                </div>

                <button type="submit" class="btn btn-primary" id="loginBtn">
                    <span class="btn-text">Sign In as Admin</span>
                    <span class="btn-loader" style="display: none;">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                            <circle cx="12" cy="12" r="10" stroke-width="3" stroke-dasharray="32"
                                stroke-dashoffset="32">
                                <animate attributeName="stroke-dashoffset" values="32;0" dur="1s"
                                    repeatCount="indefinite" />
                            </circle>
                        </svg>
                    </span>
                </button>
            </form>

            <!-- User Login Link -->
            <div class="auth-footer">
                <p>Not an admin? <a href="../index.php" class="link-primary">User Login</a></p>
            </div>
        </div>
    </div>

    <script src="../script.js"></script>
</body>

</html>