<?php
session_start();
require_once '../db.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['admin_id'];

// Fetch admin data
$sql = "SELECT * FROM users WHERE id = '$admin_id'";
$result = mysqli_query($conn, $sql);
$admin = mysqli_fetch_assoc($result);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="theme-color" content="#FF3B30">
    <title>Admin Profile</title>
    <link rel="stylesheet" href="../style.css">
</head>

<body>
    <div class="mobile-container" style="padding-bottom: 80px;">
        <div class="dashboard-wrapper">
            <!-- Header -->
            <div class="profile-header">
                <a href="dashboard.php" class="back-button">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M19 12H5M12 19l-7-7 7-7" />
                    </svg>
                </a>
                <h1 class="header-title">Admin Profile</h1>
                <div class="header-spacer"></div>
            </div>

            <!-- Profile Avatar Section -->
            <div class="profile-avatar-section">
                <div class="profile-avatar" style="background: linear-gradient(135deg, #FF3B30 0%, #FF9500 100%);">
                    <?php echo strtoupper(substr($admin['name'], 0, 1)); ?>
                </div>
                <h2 class="profile-name"><?php echo htmlspecialchars($admin['name']); ?></h2>
                <p class="profile-member-since">Admin since <?php echo date('M Y', strtotime($admin['created_at'])); ?>
                </p>
            </div>

            <!-- Admin Info -->
            <div class="form-section">
                <h3 class="section-title">Admin Information</h3>
                <div class="info-row">
                    <span class="info-label">Name</span>
                    <span class="info-value"><?php echo htmlspecialchars($admin['name']); ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Email</span>
                    <span class="info-value"><?php echo htmlspecialchars($admin['email']); ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Mobile</span>
                    <span class="info-value"><?php echo htmlspecialchars($admin['mobile']); ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Role</span>
                    <span class="info-value" style="color: #FF3B30; font-weight: 700;">Administrator</span>
                </div>
            </div>

            <!-- Logout Section -->
            <div class="form-section danger-section">
                <h3 class="section-title">Admin Actions</h3>
                <a href="logout.php" class="btn btn-danger">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                        <path
                            d="M17 7l-1.41 1.41L18.17 11H8v2h10.17l-2.58 2.58L17 17l5-5-5-5zM4 5h8V3H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h8v-2H4V5z" />
                    </svg>
                    Sign Out
                </a>
            </div>

            <div style="height: 20px;"></div>
        </div>
    </div>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <a href="dashboard.php" class="nav-item">
            <div class="nav-icon-wrapper">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z" />
                </svg>
            </div>
            <span>Dashboard</span>
        </a>

        <a href="users.php" class="nav-item">
            <div class="nav-icon-wrapper">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                    <path
                        d="M17 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2M9 11a4 4 0 100-8 4 4 0 000 8zM23 21v-2a4 4 0 00-3-3.87M16 3.13a4 4 0 010 7.75" />
                </svg>
            </div>
            <span>Users</span>
        </a>

        <a href="profile.php" class="nav-item active">
            <div class="nav-icon-wrapper">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M20 21v-2a4 4 0 00-4-4H8a4 4 0 00-4 4v2M12 11a4 4 0 100-8 4 4 0 000 8z" />
                </svg>
            </div>
            <span>Profile</span>
        </a>

        <a href="logout.php" class="nav-item">
            <div class="nav-icon-wrapper">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M9 21H5a2 2 0 01-2-2V5a2 2 0 012-2h4M16 17l5-5-5-5M21 12H9" />
                </svg>
            </div>
            <span>Logout</span>
        </a>
    </nav>

    <script src="../script.js"></script>
</body>

</html>