<?php
session_start();
require_once '../db.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit();
}

$aadhaar = $_POST['aadhaar'] ?? '';

// Validate Aadhaar number
if (empty($aadhaar) || strlen($aadhaar) !== 12 || !ctype_digit($aadhaar)) {
    echo json_encode(['success' => false, 'error' => 'Invalid Aadhaar number. Please enter 12 digits.']);
    exit();
}

// Search in search_logs table
$aadhaar = mysqli_real_escape_string($conn, $aadhaar);
$sql = "SELECT response_json FROM search_logs WHERE type = 'aadhaar' AND query = '$aadhaar' ORDER BY created_at DESC LIMIT 1";
$result = mysqli_query($conn, $sql);

if (!$result) {
    echo json_encode(['success' => false, 'error' => 'Database error: ' . mysqli_error($conn)]);
    exit();
}

if (mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    $jsonData = $row['response_json'];

    // Decode JSON
    $data = json_decode($jsonData, true);

    if (!$data) {
        echo json_encode(['success' => false, 'error' => 'Invalid JSON data in database']);
        exit();
    }

    // Extract main member (SELF)
    $mainMember = null;
    if (isset($data['memberDetailsList']) && is_array($data['memberDetailsList'])) {
        foreach ($data['memberDetailsList'] as $member) {
            if (isset($member['relationship_code']) && $member['relationship_code'] == '1') {
                $mainMember = $member;
                break;
            }
        }
    }

    // Prepare response
    $response = [
        'name' => $mainMember['memberName'] ?? ($data['memberDetailsList'][0]['memberName'] ?? 'N/A'),
        'address' => $data['address'] ?? 'N/A',
        'district' => $data['homeDistName'] ?? 'N/A',
        'state' => $data['homeStateName'] ?? 'N/A',
        'rcId' => $data['rcId'] ?? 'N/A',
        'fpsId' => $data['fpsId'] ?? 'N/A',
        'scheme' => $data['schemeName'] ?? 'N/A',
        'familyMembers' => $data['memberDetailsList'] ?? [],
        'totalMembers' => isset($data['memberDetailsList']) ? count($data['memberDetailsList']) : 0
    ];

    // Log search activity (if function exists)
    if (function_exists('log_activity')) {
        $user_id = $_SESSION['user_id'];
        log_activity($user_id, 'aadhaar_search', 'Aadhaar Search', "Searched for Aadhaar: $aadhaar");
    }

    echo json_encode([
        'success' => true,
        'data' => $response
    ]);
} else {
    echo json_encode([
        'success' => false,
        'error' => 'No data found for Aadhaar: ' . $aadhaar . '. Please check the number and try again.'
    ]);
}
?>