<?php
session_start();
require_once '../db.php';

header('Content-Type: application/json');

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit();
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

/**
 * Send message from admin to user
 */
if ($action === 'admin_send') {
    $user_id = (int) ($_POST['user_id'] ?? 0);
    $message = $_POST['message'] ?? '';

    if (!$user_id || empty($message)) {
        echo json_encode(['success' => false, 'error' => 'Invalid data']);
        exit();
    }

    $message = mysqli_real_escape_string($conn, $message);

    $sql = "INSERT INTO chat_messages (user_id, message, is_user, is_admin) 
            VALUES ($user_id, '$message', 0, 1)";

    if (mysqli_query($conn, $sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Database error']);
    }
    exit();
}

/**
 * Get new messages for real-time updates
 */
if ($action === 'get_messages') {
    $user_id = (int) ($_GET['user_id'] ?? 0);
    $after_id = (int) ($_GET['after_id'] ?? 0);

    if (!$user_id) {
        echo json_encode(['success' => false, 'error' => 'Invalid user ID']);
        exit();
    }

    $sql = "SELECT * FROM chat_messages 
            WHERE user_id = $user_id AND id > $after_id 
            ORDER BY created_at ASC";

    $result = mysqli_query($conn, $sql);
    $messages = [];

    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $messages[] = $row;
        }
    }

    echo json_encode(['success' => true, 'messages' => $messages]);
    exit();
}

echo json_encode(['success' => false, 'error' => 'Invalid action']);
?>