<?php
session_start();
require_once '../db.php';

header('Content-Type: application/json');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit();
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

// Toggle user status
if ($action === 'toggle_status') {
    $user_id = (int) ($_POST['user_id'] ?? 0);

    if (!$user_id) {
        echo json_encode(['success' => false, 'error' => 'Invalid user ID']);
        exit();
    }

    $sql = "UPDATE users SET status = IF(status = 'active', 'disabled', 'active') WHERE id = $user_id";

    if (mysqli_query($conn, $sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Database error']);
    }
    exit();
}

// Delete user
if ($action === 'delete_user') {
    $user_id = (int) ($_POST['user_id'] ?? 0);

    if (!$user_id) {
        echo json_encode(['success' => false, 'error' => 'Invalid user ID']);
        exit();
    }

    $sql = "DELETE FROM users WHERE id = $user_id AND role = 'user'";

    if (mysqli_query($conn, $sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Failed to delete user']);
    }
    exit();
}

// Get system stats
if ($action === 'get_stats') {
    $stats = [
        'total_users' => mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM users WHERE role='user'"))['count'],
        'active_users' => mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM users WHERE role='user' AND status='active'"))['count'],
        'total_searches' => mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM searches"))['count'],
        'today_searches' => mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as count FROM searches WHERE DATE(created_at) = CURDATE()"))['count']
    ];

    echo json_encode(['success' => true, 'stats' => $stats]);
    exit();
}

// Bulk delete users
if ($action === 'bulk_delete') {
    $user_ids = $_POST['user_ids'] ?? [];

    if (empty($user_ids)) {
        echo json_encode(['success' => false, 'error' => 'No users selected']);
        exit();
    }

    $ids = implode(',', array_map('intval', $user_ids));
    $sql = "DELETE FROM users WHERE id IN ($ids) AND role = 'user'";

    if (mysqli_query($conn, $sql)) {
        echo json_encode(['success' => true, 'deleted' => mysqli_affected_rows($conn)]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Failed to delete users']);
    }
    exit();
}

echo json_encode(['success' => false, 'error' => 'Invalid action']);
?>