<?php
session_start();
require_once '../db.php';

// CORS headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'Not authenticated']);
    exit();
}

$user_id = $_SESSION['user_id'];
$action = $_POST['action'] ?? $_GET['action'] ?? '';

// Gemini API Configuration
define('GEMINI_API_KEY', 'AIzaSyBMGaTFq5VoWxDuuYGQJ-1sqkeQFXSM4Vo'); // User will add their key
define('GEMINI_API_URL', 'https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent');

/**
 * Send message to Gemini AI
 */
function send_to_gemini($message, $context = [])
{
    $api_key = GEMINI_API_KEY;

    // Build context-aware prompt
    $system_context = "You are a helpful AI assistant for a mobile number search platform. ";
    $system_context .= "Help users with their queries about the platform, mobile searches, and general questions. ";
    $system_context .= "Be concise and friendly. ";

    if (!empty($context)) {
        $system_context .= "\n\nUser Context:\n";
        $system_context .= "- Name: " . ($context['name'] ?? 'User') . "\n";
        $system_context .= "- Recent searches: " . ($context['recent_searches'] ?? 'None') . "\n";
    }

    $full_prompt = $system_context . "\n\nUser: " . $message . "\n\nAssistant:";

    $data = [
        'contents' => [
            [
                'parts' => [
                    ['text' => $full_prompt]
                ]
            ]
        ]
    ];

    $ch = curl_init(GEMINI_API_URL . '?key=' . $api_key);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Reduced timeout

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);
    curl_close($ch);

    // If API fails, use fallback responses
    if ($curl_error || $http_code !== 200) {
        return get_fallback_response($message, $context);
    }

    $result = json_decode($response, true);

    if (isset($result['candidates'][0]['content']['parts'][0]['text'])) {
        return $result['candidates'][0]['content']['parts'][0]['text'];
    }

    if (isset($result['error'])) {
        return get_fallback_response($message, $context);
    }

    return get_fallback_response($message, $context);
}

/**
 * Get fallback response when AI is unavailable
 */
function get_fallback_response($message, $context = [])
{
    $message_lower = strtolower($message);

    // Greetings
    if (preg_match('/\b(hi|hello|hey|namaste)\b/i', $message_lower)) {
        $name = $context['name'] ?? 'there';
        return "Hello $name! 👋 I'm here to help you with mobile number searches. How can I assist you today?";
    }

    // Help/How to use
    if (preg_match('/\b(help|how|use|search)\b/i', $message_lower)) {
        return "I can help you with:\n\n📱 Mobile Number Search - Enter any 10-digit mobile number to get details\n📊 Search History - View your past searches\n👤 Profile - Manage your account\n\nJust type your question or use the search page!";
    }

    // Search related
    if (preg_match('/\b(search|find|number|mobile)\b/i', $message_lower)) {
        return "To search for a mobile number:\n\n1. Go to the Search page 🔍\n2. Enter a 10-digit mobile number\n3. Click 'Search'\n4. View detailed information!\n\nYou can search from our database or external APIs.";
    }

    // History
    if (preg_match('/\b(history|past|previous)\b/i', $message_lower)) {
        $recent = $context['recent_searches'] ?? 'None';
        return "Your recent searches: $recent\n\nVisit the History page 🕐 to see all your past searches with full details!";
    }

    // Profile/Account
    if (preg_match('/\b(profile|account|password|settings)\b/i', $message_lower)) {
        return "You can manage your account from the Profile page 👤:\n\n• Update personal information\n• Change password\n• Upload profile picture\n• View account details";
    }

    // Thank you
    if (preg_match('/\b(thank|thanks)\b/i', $message_lower)) {
        return "You're welcome! 😊 Feel free to ask if you need anything else!";
    }

    // Default response
    return "I'm currently running in offline mode. Here's what I can help with:\n\n📱 Mobile Search\n📊 View History\n👤 Profile Management\n\nFor detailed help, please ask specific questions or switch to Admin chat mode to talk with our team!";
}


/**
 * Get user context for AI
 */
function get_user_context($user_id)
{
    global $conn;

    // Get user info
    $user_sql = "SELECT name FROM users WHERE id = $user_id";
    $user_result = mysqli_query($conn, $user_sql);
    $user = mysqli_fetch_assoc($user_result);

    // Get recent searches
    $search_sql = "SELECT mobile FROM search_history WHERE user_id = $user_id ORDER BY searched_at DESC LIMIT 3";
    $search_result = mysqli_query($conn, $search_sql);
    $searches = [];
    while ($row = mysqli_fetch_assoc($search_result)) {
        $searches[] = $row['mobile'];
    }

    return [
        'name' => $user['name'] ?? 'User',
        'recent_searches' => implode(', ', $searches)
    ];
}

/**
 * Save chat message
 */
function save_message($user_id, $message, $is_user = true, $is_admin = false)
{
    global $conn;

    $message = mysqli_real_escape_string($conn, $message);
    $is_user = $is_user ? 1 : 0;
    $is_admin = $is_admin ? 1 : 0;

    $sql = "INSERT INTO chat_messages (user_id, message, is_user, is_admin) 
            VALUES ($user_id, '$message', $is_user, $is_admin)";

    return mysqli_query($conn, $sql);
}

/**
 * Get chat history
 */
function get_chat_history($user_id, $limit = 50)
{
    global $conn;

    $sql = "SELECT * FROM chat_messages 
            WHERE user_id = $user_id 
            ORDER BY created_at DESC 
            LIMIT $limit";

    $result = mysqli_query($conn, $sql);
    $messages = [];

    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $messages[] = $row;
        }
    }

    return array_reverse($messages);
}

// Handle actions
switch ($action) {
    case 'send':
        $message = $_POST['message'] ?? '';
        $chat_mode = $_POST['mode'] ?? 'ai'; // 'ai' or 'admin'

        if (empty($message)) {
            echo json_encode(['success' => false, 'error' => 'Message is required']);
            exit();
        }

        // Save user message
        save_message($user_id, $message, true, false);

        if ($chat_mode === 'ai') {
            // Get AI response
            $context = get_user_context($user_id);
            $ai_response = send_to_gemini($message, $context);

            // Save AI response
            save_message($user_id, $ai_response, false, false);

            echo json_encode([
                'success' => true,
                'response' => $ai_response,
                'mode' => 'ai'
            ]);
        } else {
            // Admin chat mode - just save message
            echo json_encode([
                'success' => true,
                'message' => 'Message sent to admin',
                'mode' => 'admin'
            ]);
        }
        break;

    case 'history':
        $messages = get_chat_history($user_id);
        echo json_encode([
            'success' => true,
            'messages' => $messages
        ]);
        break;

    case 'clear':
        $sql = "DELETE FROM chat_messages WHERE user_id = $user_id";
        mysqli_query($conn, $sql);
        echo json_encode(['success' => true]);
        break;

    default:
        echo json_encode(['success' => false, 'error' => 'Invalid action']);
}
?>