<?php
session_start();
require_once 'db.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

$user_id = $_SESSION['user_id'];

// Get search history
$history = get_user_search_history($user_id, 50);

/**
 * Get user search history
 */
function get_user_search_history($user_id, $limit = 50)
{
    global $conn;
    $user_id = (int) $user_id;
    $limit = (int) $limit;

    $sql = "SELECT sh.*, mi.name, mi.circle, mi.operator 
            FROM search_history sh
            LEFT JOIN mobile_info mi ON sh.mobile = mi.mobile
            WHERE sh.user_id = $user_id 
            ORDER BY sh.searched_at DESC 
            LIMIT $limit";

    $result = mysqli_query($conn, $sql);
    $history = [];

    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $history[] = $row;
        }
    }

    return $history;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="theme-color" content="#007AFF">
    <title>Search History</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .history-container {
            padding: 20px;
            padding-bottom: 80px;
        }

        .history-header {
            margin-bottom: 24px;
        }

        .history-title {
            font-size: 28px;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 8px;
        }

        .history-subtitle {
            font-size: 14px;
            color: var(--text-secondary);
        }

        .history-list {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .history-item {
            background: white;
            border-radius: 12px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.06);
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .history-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--bg-secondary);
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .history-icon svg {
            width: 20px;
            height: 20px;
        }

        .history-content {
            flex: 1;
        }

        .history-mobile {
            font-size: 15px;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 4px;
        }

        .history-info {
            font-size: 13px;
            color: var(--text-secondary);
        }

        .history-time {
            font-size: 12px;
            color: var(--text-secondary);
            text-align: right;
        }

        .history-badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 8px;
            font-size: 11px;
            font-weight: 600;
            margin-left: 8px;
        }

        .badge-found-db {
            background: rgba(52, 199, 89, 0.1);
            color: #34C759;
        }

        .badge-found-api {
            background: rgba(0, 122, 255, 0.1);
            color: #007AFF;
        }

        .badge-not-found {
            background: rgba(255, 149, 0, 0.1);
            color: #FF9500;
        }

        .badge-api-down {
            background: rgba(255, 59, 48, 0.1);
            color: #FF3B30;
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
        }

        .empty-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
            border-radius: 50%;
            background: var(--bg-secondary);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .empty-icon svg {
            width: 40px;
            height: 40px;
        }

        .empty-title {
            font-size: 18px;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 8px;
        }

        .empty-message {
            font-size: 14px;
            color: var(--text-secondary);
        }
    </style>
</head>

<body>
    <div class="mobile-container">
        <div class="history-container">
            <!-- Header -->
            <div class="history-header">
                <h1 class="history-title">Search History</h1>
                <p class="history-subtitle">Your recent mobile number searches</p>
            </div>

            <!-- History List -->
            <?php if (count($history) > 0): ?>
                <div class="history-list">
                    <?php foreach ($history as $item): ?>
                        <div class="history-item">
                            <div class="history-icon">
                                <svg viewBox="0 0 24 24" fill="none" stroke="#8E8E93" stroke-width="2">
                                    <circle cx="12" cy="12" r="10" />
                                    <polyline points="12 6 12 12 16 14" />
                                </svg>
                            </div>
                            <div class="history-content">
                                <div class="history-mobile">
                                    <?php echo htmlspecialchars($item['mobile']); ?>
                                    <?php
                                    $badge_class = 'badge-' . str_replace('_', '-', $item['search_result']);
                                    $badge_text = ucwords(str_replace('_', ' ', $item['search_result']));
                                    ?>
                                    <span class="history-badge <?php echo $badge_class; ?>">
                                        <?php echo $badge_text; ?>
                                    </span>
                                </div>
                                <div class="history-info">
                                    <?php if ($item['name']): ?>
                                        <?php echo htmlspecialchars($item['name']); ?>
                                        <?php if ($item['operator']): ?>
                                            • <?php echo htmlspecialchars($item['operator']); ?>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        No data available
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="history-time">
                                <?php echo time_ago($item['searched_at']); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <div class="empty-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="#8E8E93" stroke-width="2">
                            <circle cx="11" cy="11" r="8" />
                            <path d="m21 21-4.35-4.35" />
                        </svg>
                    </div>
                    <div class="empty-title">No Search History</div>
                    <div class="empty-message">Your search history will appear here</div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Bottom Navigation -->
    <?php include 'navbar.php'; ?>

    <script src="script.js"></script>

    <!-- AI Chatbot -->
    <?php include 'chat_widget.php'; ?>
</body>

</html>