<?php
session_start();
require_once 'db.php';

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit();
}

$error = '';
$success = '';


// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email_or_mobile = sanitize_input($_POST['email_or_mobile']);
    $password = $_POST['password'];

    // Get user IP
    $ip_address = $_SERVER['REMOTE_ADDR'];

    // Validation
    if (empty($email_or_mobile) || empty($password)) {
        $error = 'All fields are required';
    }
    // Check rate limit
    elseif (check_rate_limit($email_or_mobile, $ip_address)) {
        $error = 'Too many failed login attempts. Please try again in 15 minutes.';
    } else {
        // Check if input is email or mobile
        $field = validate_email($email_or_mobile) ? 'email' : 'mobile';

        // Query user with status check
        $sql = "SELECT * FROM users WHERE $field = '$email_or_mobile' AND role = 'user'";
        $result = mysqli_query($conn, $sql);

        if (mysqli_num_rows($result) > 0) {
            $user = mysqli_fetch_assoc($result);

            // Check if user is actually an admin (admins should use admin login)
            if (isset($user['role']) && $user['role'] == 'admin') {
                $error = 'Admin users must login through Admin Panel.';
            }
            // Check if user is disabled
            elseif (isset($user['status']) && $user['status'] == 'disabled') {
                $error = 'Your account has been disabled. Please contact administrator.';
            }
            // Verify password
            elseif (password_verify($password, $user['password'])) {
                // Login successful
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['user_email'] = $user['email'];

                // Log successful login attempt
                log_login_attempt($email_or_mobile, $ip_address, 1);

                // Log activity
                log_activity($user['id'], 'login', 'Login Successful', 'User logged in successfully');

                // Set success message for toast
                $_SESSION['toast_success'] = 'Welcome back! Login successful.';

                // Set welcome notice flag
                $_SESSION['show_welcome_notice'] = true;

                header('Location: dashboard.php');
                exit();
            } else {
                // Log failed login attempt
                log_login_attempt($email_or_mobile, $ip_address, 0);
                $error = 'Invalid password';
            }
        } else {
            // Log failed login attempt (user not found)
            log_login_attempt($email_or_mobile, $ip_address, 0);
            $error = 'Account not found';
        }
    }
}

// Get success message from session
if (isset($_SESSION['success'])) {
    $success = $_SESSION['success'];
    unset($_SESSION['success']);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <title>Login - Mobile App</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <div class="mobile-container">
        <div class="auth-wrapper">
            <!-- App Icon -->
            <div class="app-icon">
                <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="64" height="64" rx="16" fill="#007AFF" />
                    <path
                        d="M32 20C25.37 20 20 25.37 20 32C20 38.63 25.37 44 32 44C38.63 44 44 38.63 44 32C44 25.37 38.63 20 32 20ZM32 36C29.79 36 28 34.21 28 32C28 29.79 29.79 28 32 28C34.21 28 36 29.79 36 32C36 34.21 34.21 36 32 36Z"
                        fill="white" />
                </svg>
            </div>

            <!-- Page Title -->
            <h1 class="page-title">Welcome Back</h1>
            <p class="page-subtitle">Sign in to continue</p>

            <!-- Alert Messages -->
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" />
                    </svg>
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <?php if ($success): ?>
                <div class="alert alert-success">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" />
                    </svg>
                    <?php echo $success; ?>
                </div>
            <?php endif; ?>

            <!-- Login Form -->
            <form method="POST" action="" class="auth-form" id="loginForm">
                <div class="form-group">
                    <label for="email_or_mobile">Email or Mobile Number</label>
                    <input type="text" id="email_or_mobile" name="email_or_mobile" placeholder="Enter email or mobile"
                        required autocomplete="username">
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" placeholder="Enter your password" required
                        autocomplete="current-password">
                </div>

                <div class="form-footer">
                    <a href="#" class="link-text">Forgot Password?</a>
                </div>

                <button type="submit" class="btn btn-primary" id="loginBtn">
                    <span class="btn-text">Sign In</span>
                    <span class="btn-loader" style="display: none;">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                            <circle cx="12" cy="12" r="10" stroke-width="3" stroke-dasharray="32"
                                stroke-dashoffset="32">
                                <animate attributeName="stroke-dashoffset" values="32;0" dur="1s"
                                    repeatCount="indefinite" />
                            </circle>
                        </svg>
                    </span>
                </button>
            </form>

            <!-- Register Link -->
            <div class="auth-footer">
                <p>Don't have an account? <a href="register.php" class="link-primary">Register</a></p>
            </div>
        </div>
    </div>

    <script src="script.js"></script>
</body>

</html>