<?php
session_start();
require_once 'db.php';

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit();
}

$error = '';
$success = '';

// Handle registration form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = sanitize_input($_POST['name']);
    $email = sanitize_input($_POST['email']);
    $mobile = sanitize_input($_POST['mobile']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    // Validation
    if (empty($name) || empty($email) || empty($mobile) || empty($password) || empty($confirm_password)) {
        $error = 'All fields are required';
    } elseif (!validate_email($email)) {
        $error = 'Invalid email format';
    } elseif (!validate_mobile($mobile)) {
        $error = 'Mobile number must be 10-15 digits';
    } elseif (strlen($password) < 6) {
        $error = 'Password must be at least 6 characters';
    } elseif ($password !== $confirm_password) {
        $error = 'Passwords do not match';
    } elseif (email_exists($email)) {
        $error = 'Email already registered';
    } elseif (mobile_exists($mobile)) {
        $error = 'Mobile number already registered';
    } else {
        // Hash password
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        // Insert user
        $sql = "INSERT INTO users (name, email, mobile, password) VALUES ('$name', '$email', '$mobile', '$hashed_password')";

        if (mysqli_query($conn, $sql)) {
            // Get the new user ID
            $new_user_id = mysqli_insert_id($conn);

            // Log activity
            log_activity($new_user_id, 'register', 'Account Created', 'New user account created successfully');

            $_SESSION['success'] = 'Registration successful! Please login.';
            header('Location: index.php');
            exit();
        } else {
            $error = 'Registration failed. Please try again.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <title>Register - Mobile App</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <div class="mobile-container">
        <div class="auth-wrapper">
            <!-- App Icon -->
            <div class="app-icon">
                <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="64" height="64" rx="16" fill="#34C759" />
                    <path
                        d="M32 20C25.37 20 20 25.37 20 32C20 38.63 25.37 44 32 44C38.63 44 44 38.63 44 32C44 25.37 38.63 20 32 20ZM32 26C34.21 26 36 27.79 36 30C36 32.21 34.21 34 32 34C29.79 34 28 32.21 28 30C28 27.79 29.79 26 32 26ZM32 42C28.67 42 25.8 40.34 24 37.84C24.04 35.29 29.33 33.9 32 33.9C34.66 33.9 39.96 35.29 40 37.84C38.2 40.34 35.33 42 32 42Z"
                        fill="white" />
                </svg>
            </div>

            <!-- Page Title -->
            <h1 class="page-title">Create Account</h1>
            <p class="page-subtitle">Sign up to get started</p>

            <!-- Alert Messages -->
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" />
                    </svg>
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <!-- Registration Form -->
            <form method="POST" action="" class="auth-form" id="registerForm">
                <div class="form-group">
                    <label for="name">Full Name</label>
                    <input type="text" id="name" name="name" placeholder="Enter your full name" required
                        autocomplete="name"
                        value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>">
                </div>

                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" id="email" name="email" placeholder="your@email.com" required
                        autocomplete="email"
                        value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>">
                </div>

                <div class="form-group">
                    <label for="mobile">Mobile Number</label>
                    <input type="tel" id="mobile" name="mobile" placeholder="10-digit mobile number" required
                        pattern="[0-9]{10,15}" autocomplete="tel"
                        value="<?php echo isset($_POST['mobile']) ? htmlspecialchars($_POST['mobile']) : ''; ?>">
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" placeholder="Minimum 6 characters" required
                        minlength="6" autocomplete="new-password">
                    <div class="password-strength" id="passwordStrength"></div>
                </div>

                <div class="form-group">
                    <label for="confirm_password">Confirm Password</label>
                    <input type="password" id="confirm_password" name="confirm_password" placeholder="Re-enter password"
                        required minlength="6" autocomplete="new-password">
                </div>

                <button type="submit" class="btn btn-primary" id="registerBtn">
                    <span class="btn-text">Create Account</span>
                    <span class="btn-loader" style="display: none;">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                            <circle cx="12" cy="12" r="10" stroke-width="3" stroke-dasharray="32"
                                stroke-dashoffset="32">
                                <animate attributeName="stroke-dashoffset" values="32;0" dur="1s"
                                    repeatCount="indefinite" />
                            </circle>
                        </svg>
                    </span>
                </button>
            </form>

            <!-- Login Link -->
            <div class="auth-footer">
                <p>Already have an account? <a href="index.php" class="link-primary">Sign In</a></p>
            </div>
        </div>
    </div>

    <script src="script.js"></script>
</body>

</html>