<?php
require_once 'db.php';

echo "<h2>Setting up Aadhaar Data Table...</h2>";

// Create table
$sql = "CREATE TABLE IF NOT EXISTS aadhaar_data (
    id INT AUTO_INCREMENT PRIMARY KEY,
    aadhaar_number VARCHAR(12) UNIQUE NOT NULL,
    data JSON NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_aadhaar (aadhaar_number)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if (mysqli_query($conn, $sql)) {
    echo "✓ Table 'aadhaar_data' created<br>";
} else {
    echo "✗ Error: " . mysqli_error($conn) . "<br>";
}

// Insert sample data
echo "<br><h3>Inserting Sample Data...</h3>";

$samples = [
    ['123456789012', '{"name": "Rajesh Kumar", "dob": "1990-05-15", "gender": "Male", "address": "123 MG Road, Bangalore, Karnataka", "photo": ""}'],
    ['234567890123', '{"name": "Priya Sharma", "dob": "1995-08-20", "gender": "Female", "address": "456 Park Street, Mumbai, Maharashtra", "photo": ""}'],
    ['345678901234', '{"name": "Amit Patel", "dob": "1988-12-10", "gender": "Male", "address": "789 Gandhi Nagar, Delhi", "photo": ""}'],
    ['456789012345', '{"name": "Sunita Verma", "dob": "1992-03-25", "gender": "Female", "address": "321 Lake View, Pune, Maharashtra", "photo": ""}'],
    ['567890123456', '{"name": "Vikram Singh", "dob": "1985-11-30", "gender": "Male", "address": "654 Hill Station, Shimla, Himachal Pradesh", "photo": ""}']
];

foreach ($samples as $sample) {
    list($aadhaar, $data) = $sample;
    $data = mysqli_real_escape_string($conn, $data);

    $insert_sql = "INSERT INTO aadhaar_data (aadhaar_number, data) 
                   VALUES ('$aadhaar', '$data')
                   ON DUPLICATE KEY UPDATE data='$data'";

    if (mysqli_query($conn, $insert_sql)) {
        echo "✓ Added Aadhaar: $aadhaar<br>";
    } else {
        echo "✗ Error: " . mysqli_error($conn) . "<br>";
    }
}

echo "<br>✅ <strong>Aadhaar Data Setup Complete!</strong><br>";
echo "<br><p>Sample Aadhaar numbers to test:</p>";
echo "<ul>";
foreach ($samples as $sample) {
    echo "<li><code>{$sample[0]}</code></li>";
}
echo "</ul>";

echo "<br><a href='search.php' style='
    display: inline-block;
    padding: 10px 20px;
    background: linear-gradient(135deg, #FF9500 0%, #FF5E3A 100%);
    color: white;
    text-decoration: none;
    border-radius: 8px;
    font-weight: 600;
'>Go to Search Page</a>";
?>