<?php
require_once 'db.php';

echo "<h2>Creating Announcements Table...</h2>";

// Create announcements table
$sql = "CREATE TABLE IF NOT EXISTS announcements (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    content TEXT NOT NULL,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_status (status),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if (mysqli_query($conn, $sql)) {
    echo "✓ Table 'announcements' created successfully<br>";
} else {
    echo "✗ Error creating table: " . mysqli_error($conn) . "<br>";
}

// Insert sample announcements
$announcements = [
    [
        'title' => 'Welcome to Our Platform!',
        'content' => 'Thank you for joining us. Explore all features and enjoy your experience.',
        'status' => 'active'
    ],
    [
        'title' => 'System Update',
        'content' => 'We have updated our system with new features and improvements.',
        'status' => 'active'
    ],
    [
        'title' => 'Important Notice',
        'content' => 'Currently we don\'t have all mobile number data. We are working to expand our database.',
        'status' => 'active'
    ]
];

echo "<br><h3>Inserting Sample Announcements...</h3>";

foreach ($announcements as $announcement) {
    $title = mysqli_real_escape_string($conn, $announcement['title']);
    $content = mysqli_real_escape_string($conn, $announcement['content']);
    $status = $announcement['status'];

    $insert_sql = "INSERT INTO announcements (title, content, status) VALUES ('$title', '$content', '$status')";

    if (mysqli_query($conn, $insert_sql)) {
        echo "✓ Added: {$announcement['title']}<br>";
    } else {
        echo "✗ Error: " . mysqli_error($conn) . "<br>";
    }
}

echo "<br>✅ <strong>Setup Complete!</strong><br>";
echo "<br><a href='dashboard.php' style='
    display: inline-block;
    padding: 10px 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    text-decoration: none;
    border-radius: 8px;
    font-weight: 600;
'>Go to Dashboard</a>";
?>