<?php
require_once 'db.php';

echo "Creating chat tables...\n\n";

// Create chat_messages table
$sql1 = "CREATE TABLE IF NOT EXISTS chat_messages (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    message TEXT NOT NULL,
    is_user BOOLEAN DEFAULT TRUE,
    is_admin BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if (mysqli_query($conn, $sql1)) {
    echo "✓ Table 'chat_messages' created successfully\n";
} else {
    echo "✗ Error creating chat_messages: " . mysqli_error($conn) . "\n";
}

// Create chat_settings table
$sql2 = "CREATE TABLE IF NOT EXISTS chat_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    ai_enabled BOOLEAN DEFAULT TRUE,
    admin_chat_enabled BOOLEAN DEFAULT TRUE,
    last_seen TIMESTAMP NULL,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    UNIQUE KEY unique_user (user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if (mysqli_query($conn, $sql2)) {
    echo "✓ Table 'chat_settings' created successfully\n";
} else {
    echo "✗ Error creating chat_settings: " . mysqli_error($conn) . "\n";
}

echo "\n✅ Chat database setup complete!\n";
echo "\nNow visit: http://localhost/app/dashboard.php\n";
echo "Click the purple chat button to test!\n";
?>