<?php
require_once 'db.php';

echo "<h2>Adding Profile Image Column...</h2>";

// Add profile_image column
$sql = "ALTER TABLE users ADD COLUMN IF NOT EXISTS profile_image VARCHAR(255) DEFAULT NULL AFTER email";

if (mysqli_query($conn, $sql)) {
    echo "✅ <strong>Success!</strong> Profile image column added to users table.<br>";
} else {
    // Check if column already exists
    if (strpos(mysqli_error($conn), 'Duplicate column') !== false) {
        echo "✅ <strong>Column already exists!</strong> No changes needed.<br>";
    } else {
        echo "❌ <strong>Error:</strong> " . mysqli_error($conn) . "<br>";
    }
}

echo "<br><a href='dashboard.php' style='
    display: inline-block;
    padding: 10px 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    text-decoration: none;
    border-radius: 8px;
    font-weight: 600;
'>Go to Dashboard</a>";
?>