<?php
require_once 'db.php';

echo "<h2>Setting up Search Logs Table...</h2>";

// Create table
$sql = "CREATE TABLE IF NOT EXISTS search_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    type VARCHAR(50) NOT NULL,
    query VARCHAR(255) NOT NULL,
    response_json TEXT,
    cost DECIMAL(10,2) DEFAULT 0,
    status VARCHAR(50) DEFAULT 'success',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_type (type),
    INDEX idx_query (query),
    INDEX idx_user (user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if (mysqli_query($conn, $sql)) {
    echo "✓ Table 'search_logs' created<br>";
} else {
    echo "✗ Error: " . mysqli_error($conn) . "<br>";
}

// Insert sample Aadhaar data
echo "<br><h3>Inserting Sample Aadhaar Data...</h3>";

$samples = [
    [
        'user_id' => 1,
        'query' => '931894246237',
        'response' => '{"address":"W O Rudrappa K . . jayanthi nagara near anjaneya temple Nallur","allowed_onorc":"Yes","districtCode":"567","dup_uid_status":"No","fpsId":"757211","homeDistName":"DAVANGERE","homeStateCode":"29","homeStateName":"KARNATAKA","memberDetailsList":[{"memberId":"1201001960411","memberName":"Sumalatha S","relationship_code":"1","releationship_name":"SELF","uid":"Yes"},{"memberId":"1201001960414","memberName":"Yuktha J R","relationship_code":"9","releationship_name":"DAUGHTER","uid":"Yes"},{"memberId":"1201001960410","memberName":"RUDRAPPA.K","relationship_code":"7","releationship_name":"HUSBAND","uid":"Yes"},{"memberId":"1201001960413","memberName":"Dhanush J R","relationship_code":"8","releationship_name":"SON","uid":"Yes"}],"rcId":"120100196041","schemeId":"PHH","schemeName":"PHH"}'
    ],
    [
        'user_id' => 1,
        'query' => '808262365427',
        'response' => '{"address":"HUCHAVANAHALLI DAVANGERE T.D.","allowed_onorc":"Yes","districtCode":"567","dup_uid_status":"No","fpsId":"7896217","homeDistName":"DAVANGERE","homeStateCode":"29","homeStateName":"KARNATAKA","memberDetailsList":[{"memberId":"1202002764801","memberName":"VINAMALMAM","relationship_code":"1","releationship_name":"SELF","uid":"Yes"},{"memberId":"12020027648010","memberName":"Sanvi R","relationship_code":"34","releationship_name":"GRAND SON","uid":"Yes"},{"memberId":"1202002764809","memberName":"N M Sowmya","relationship_code":"48","releationship_name":"DAUGHTER IN LAW","uid":"Yes"},{"memberId":"1202002764804","memberName":"Dayanand D","relationship_code":"8","releationship_name":"SON","uid":"Yes"},{"memberId":"1202002764808","memberName":"RUDRERSH","relationship_code":"8","releationship_name":"SON","uid":"Yes"},{"memberId":"1202002764805","memberName":"Sujatha","relationship_code":"48","releationship_name":"DAUGHTER IN LAW","uid":"Yes"},{"memberId":"1202002764806","memberName":"Vereesh D","relationship_code":"34","releationship_name":"GRAND SON","uid":"Yes"},{"memberId":"1202002764807","memberName":"Yashavanth D","relationship_code":"34","releationship_name":"GRAND SON","uid":"Yes"}],"rcId":"120200276480","schemeId":"PHH","schemeName":"PHH"}'
    ],
    [
        'user_id' => 1,
        'query' => '701728922808',
        'response' => '{"address":"S O Shivamurthappa 8 Basaveshwara Nagar Nallur Lingadalli Circle CHANNAGIRI DAVANAGERE-577221.","allowed_onorc":"Yes","districtCode":"567","dup_uid_status":"No","fpsId":"757211","homeDistName":"DAVANGERE","homeStateCode":"29","homeStateName":"KARNATAKA","memberDetailsList":[{"memberId":"1201002359962","memberName":"H N KAMALAMMA","relationship_code":"1","releationship_name":"SELF","uid":"Yes"},{"memberId":"1201002359963","memberName":"K S CHANDANA","relationship_code":"9","releationship_name":"DAUGHTER","uid":"Yes"},{"memberId":"1201002359964","memberName":"Sinchana K S","relationship_code":"9","releationship_name":"DAUGHTER","uid":"Yes"},{"memberId":"1201002359961","memberName":"S SHANTHAVEERAPPA","relationship_code":"7","releationship_name":"HUSBAND","uid":"Yes"}],"rcId":"120100235996","schemeId":"PHH","schemeName":"PHH"}'
    ]
];

foreach ($samples as $sample) {
    $user_id = $sample['user_id'];
    $query = mysqli_real_escape_string($conn, $sample['query']);
    $response = mysqli_real_escape_string($conn, $sample['response']);

    $insert_sql = "INSERT INTO search_logs (user_id, type, query, response_json, cost, status) 
                   VALUES ($user_id, 'aadhaar', '$query', '$response', 5.0, 'success')
                   ON DUPLICATE KEY UPDATE response_json='$response'";

    if (mysqli_query($conn, $insert_sql)) {
        echo "✓ Added Aadhaar: $query<br>";
    } else {
        echo "✗ Error: " . mysqli_error($conn) . "<br>";
    }
}

echo "<br>✅ <strong>Search Logs Setup Complete!</strong><br>";
echo "<br><p><strong>Test Aadhaar Numbers:</strong></p>";
echo "<ul>";
echo "<li><code>931894246237</code> - Sumalatha S (4 members)</li>";
echo "<li><code>808262365427</code> - VINAMALMAM (8 members)</li>";
echo "<li><code>701728922808</code> - H N KAMALAMMA (4 members)</li>";
echo "</ul>";

echo "<br><a href='search.php' style='
    display: inline-block;
    padding: 10px 20px;
    background: linear-gradient(135deg, #FF9500 0%, #FF5E3A 100%);
    color: white;
    text-decoration: none;
    border-radius: 8px;
    font-weight: 600;
'>Go to Search Page</a>";

echo " <a href='test_aadhaar.html' style='
    display: inline-block;
    padding: 10px 20px;
    background: linear-gradient(135deg, #007AFF 0%, #0051D5 100%);
    color: white;
    text-decoration: none;
    border-radius: 8px;
    font-weight: 600;
    margin-left: 10px;
'>Test API</a>";
?>