# Telegram Notification Setup Guide

## 🤖 Step 1: Create Telegram Bot

1. **Open Telegram** and search for `@BotFather`
2. **Send:** `/newbot`
3. **Enter bot name:** e.g., "My Platform Bot"
4. **Enter bot username:** e.g., "myplatform_bot"
5. **Copy the token** (looks like: `123456789:ABCdefGHIjklMNOpqrsTUVwxyz`)

## 🔑 Step 2: Configure Bot Token

**File:** `config/config.php`

```php
define('TELEGRAM_BOT_TOKEN', 'YOUR_BOT_TOKEN_HERE');
```

## 💬 Step 3: Get Your Chat ID (Admin)

### Method 1: Using getUpdates API

1. **Send `/start` to your bot** on Telegram
2. **Visit this URL** in browser:
   ```
   https://api.telegram.org/botYOUR_BOT_TOKEN/getUpdates
   ```
3. **Look for:** `"chat":{"id":123456789}`
4. **Copy the chat ID** (the number)

### Method 2: Using @userinfobot

1. **Search for** `@userinfobot` on Telegram
2. **Send any message**
3. **Bot will reply with your ID**

## ⚙️ Step 4: Update Config

**File:** `config/config.php`

```php
define('TELEGRAM_CHAT_ID', 'YOUR_CHAT_ID_HERE');
```

## 👤 Step 5: User Telegram Setup

### For Users to Receive Notifications:

1. **User adds their Telegram chat_id** in Profile page
2. **User must start a chat** with your bot first (send `/start`)
3. **Get their chat_id** using one of these methods:
   - Use @userinfobot
   - Or visit: `https://api.telegram.org/botYOUR_BOT_TOKEN/getUpdates` after they send `/start`

### Important Notes:

- ⚠️ **Telegram number field = chat_id** (not phone number!)
- ✅ Users must `/start` the bot before receiving messages
- ✅ chat_id is usually a 9-10 digit number

## 🧪 Step 6: Test Notifications

### Test Script:
```
http://localhost/gravity/public/test-telegram.php
```

This will:
- ✅ Check configuration
- ✅ Send test message to admin
- ✅ Send test message to user (if telegram number added)
- ✅ Show error logs
- ✅ Provide troubleshooting tips

## 📱 Step 7: How Notifications Work

### Admin Notifications (TELEGRAM_CHAT_ID):
- New user registration
- Payment received
- New search performed
- API failures

### User Notifications (user's telegram_number):
- Payment success
- Subscription activated
- Search completed

## 🔍 Troubleshooting

### "Failed to send message"

**Possible Causes:**
1. ❌ Bot token incorrect
2. ❌ Chat ID incorrect
3. ❌ User hasn't started bot
4. ❌ Bot blocked by user

**Solutions:**
1. ✅ Verify bot token in config.php
2. ✅ Get correct chat_id from getUpdates
3. ✅ User must send `/start` to bot
4. ✅ User must unblock bot

### "Unauthorized" Error

**Cause:** Bot token is incorrect

**Solution:** 
1. Create new bot with @BotFather
2. Copy correct token
3. Update config.php

### User Not Receiving Notifications

**Checklist:**
- [ ] User added chat_id in profile
- [ ] User sent `/start` to bot
- [ ] Bot not blocked by user
- [ ] chat_id is correct (numeric)

## 📊 Testing Flow

```
1. Admin Setup:
   ├─ Create bot → Get token
   ├─ Send /start to bot
   ├─ Get chat_id
   └─ Update config.php

2. User Setup:
   ├─ Send /start to bot
   ├─ Get their chat_id
   ├─ Add in profile
   └─ Test with payment/search

3. Verify:
   ├─ Run test-telegram.php
   ├─ Check error logs
   └─ Confirm messages received
```

## 🎯 Quick Reference

| Item | Where to Find |
|------|---------------|
| Bot Token | @BotFather after `/newbot` |
| Admin Chat ID | Send `/start`, then getUpdates |
| User Chat ID | User sends `/start`, then getUpdates |
| Test Script | `/public/test-telegram.php` |
| Error Logs | `C:\xampp\apache\logs\error.log` |

## 💡 Pro Tips

1. **Save bot token securely** - Don't share publicly
2. **Test with yourself first** before asking users
3. **Use @userinfobot** for quick chat_id lookup
4. **Check error.log** for detailed error messages
5. **Users must /start bot** before receiving messages

## 🔗 Useful Links

- Bot API Docs: https://core.telegram.org/bots/api
- BotFather: https://t.me/BotFather
- UserInfoBot: https://t.me/userinfobot
- Get Updates: `https://api.telegram.org/botTOKEN/getUpdates`

---

**Need Help?** Run `test-telegram.php` for automated diagnostics!
