-- Activity Log System for Gravity Platform
-- This tracks all user activities for security and analytics

-- Create activity_logs table
CREATE TABLE IF NOT EXISTS `activity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `action` varchar(100) NOT NULL,
  `description` text,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `data` text COMMENT 'JSON data for additional info',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `action` (`action`),
  KEY `created_at` (`created_at`),
  CONSTRAINT `activity_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert some sample activity types for reference
INSERT INTO `activity_logs` (`user_id`, `action`, `description`, `ip_address`, `user_agent`, `data`) VALUES
(1, 'login', 'User logged in successfully', '127.0.0.1', 'Mozilla/5.0', '{"method":"password"}'),
(1, 'search_mobile', 'Searched mobile number', '127.0.0.1', 'Mozilla/5.0', '{"query":"9876543210","source":"api"}'),
(1, 'plan_purchase', 'Purchased subscription plan', '127.0.0.1', 'Mozilla/5.0', '{"plan":"Pro Plan","amount":999}'),
(1, 'profile_update', 'Updated profile information', '127.0.0.1', 'Mozilla/5.0', '{"fields":["name","telegram_number"]}'),
(1, 'password_change', 'Changed account password', '127.0.0.1', 'Mozilla/5.0', '{"success":true}'),
(1, 'theme_change', 'Changed theme preference', '127.0.0.1', 'Mozilla/5.0', '{"theme":"light"}'),
(1, 'logout', 'User logged out', '127.0.0.1', 'Mozilla/5.0', '{}');

-- Activity types reference:
-- login, logout, search_mobile, search_aadhaar, plan_purchase, 
-- profile_update, password_change, theme_change, export_data,
-- view_search, failed_login, session_expired

-- Verification queries
SELECT 'Activity Logs Table Created' as Status;
SELECT COUNT(*) as 'Sample Activities' FROM activity_logs;
SELECT action, COUNT(*) as count FROM activity_logs GROUP BY action;
