-- AI Chatbot Tables

-- Chatbot Settings
CREATE TABLE IF NOT EXISTS chatbot_settings (
    id INT PRIMARY KEY AUTO_INCREMENT,
    is_enabled BOOLEAN DEFAULT TRUE,
    auto_reply_delay INT DEFAULT 30, -- seconds (reduced to 30 for faster response)
    ai_provider ENUM('openai', 'gemini', 'custom') DEFAULT 'gemini',
    api_key VARCHAR(255),
    system_prompt TEXT DEFAULT 'You are a helpful AI assistant for a Mobile & Aadhaar Intelligence Platform. Help users with their queries about subscriptions, searches, and platform features. Be concise and friendly.',
    max_tokens INT DEFAULT 150,
    temperature FLOAT DEFAULT 0.7,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default settings
INSERT INTO chatbot_settings (is_enabled, api_key, system_prompt) VALUES 
(TRUE, '', 'You are a helpful AI assistant for Mobile & Aadhaar Intelligence Platform. Answer user questions about subscriptions, mobile/aadhaar searches, pricing, and features. Be concise, friendly, and helpful. If you don''t know something, suggest contacting admin.');

-- Chatbot Quick Responses (for instant replies to common questions)
CREATE TABLE IF NOT EXISTS chatbot_quick_responses (
    id INT PRIMARY KEY AUTO_INCREMENT,
    keywords TEXT NOT NULL, -- comma-separated keywords
    response TEXT NOT NULL,
    priority INT DEFAULT 0,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert common quick responses
INSERT INTO chatbot_quick_responses (keywords, response, priority, is_active) VALUES
('hello,hi,hey,namaste', 'Hello! 👋 Welcome to Mobile & Aadhaar Intelligence Platform. How can I help you today?', 10, TRUE),
('price,pricing,cost,plan,subscription', 'We offer various subscription plans:\n- Basic Plan: ₹99/month (10 searches)\n- Pro Plan: ₹299/month (50 searches)\n- Premium Plan: ₹999/month (Unlimited searches)\n\nWould you like to know more about any specific plan?', 9, TRUE),
('search,mobile,aadhaar,lookup', 'You can search for:\n📱 Mobile Number Details\n🆔 Aadhaar Information\n\nJust enter the number in the search box on your dashboard. Make sure you have an active subscription!', 8, TRUE),
('help,support,problem,issue', 'I''m here to help! 😊\n\nCommon topics:\n- Subscription plans\n- How to search\n- Payment issues\n- Account settings\n\nWhat do you need help with?', 7, TRUE),
('payment,pay,transaction', 'For payment-related queries:\n- We accept UPI, Cards, and Net Banking\n- Payments are processed securely via Razorpay\n- Contact admin for payment issues: admin@platform.com', 6, TRUE),
('thank,thanks', 'You''re welcome! 😊 Feel free to ask if you need anything else!', 5, TRUE);

-- Chatbot Conversation Logs
CREATE TABLE IF NOT EXISTS chatbot_logs (
    id INT PRIMARY KEY AUTO_INCREMENT,
    user_id INT NOT NULL,
    message_id INT,
    user_message TEXT NOT NULL,
    bot_response TEXT NOT NULL,
    response_type ENUM('quick', 'ai', 'fallback') DEFAULT 'ai',
    confidence_score FLOAT DEFAULT 0,
    processing_time_ms INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (message_id) REFERENCES chat_messages(id) ON DELETE SET NULL,
    INDEX idx_user_id (user_id),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Add column to chat_messages to track if message is from bot
ALTER TABLE chat_messages 
ADD COLUMN is_bot BOOLEAN DEFAULT FALSE AFTER sender_type;
