-- Performance Optimization: Database Indexes
-- Run this to speed up queries significantly

-- Users table indexes
ALTER TABLE users ADD INDEX idx_email (email);
ALTER TABLE users ADD INDEX idx_status (status);
ALTER TABLE users ADD INDEX idx_role (role);

-- Searches table indexes  
ALTER TABLE searches ADD INDEX idx_user_created (user_id, created_at);
ALTER TABLE searches ADD INDEX idx_search_type (search_type);
ALTER TABLE searches ADD INDEX idx_source (source);

-- Payments table indexes
ALTER TABLE payments ADD INDEX idx_user_status (user_id, status);
ALTER TABLE payments ADD INDEX idx_order_id (razorpay_order_id);
ALTER TABLE payments ADD INDEX idx_created (created_at);

-- Subscriptions table indexes
ALTER TABLE subscriptions ADD INDEX idx_user_status_end (user_id, status, end_date);
ALTER TABLE subscriptions ADD INDEX idx_status_end (status, end_date);
ALTER TABLE subscriptions ADD INDEX idx_plan_id (plan_id);

-- Plans table indexes
ALTER TABLE plans ADD INDEX idx_status (status);

-- Chat messages indexes (if table exists)
ALTER TABLE chat_messages ADD INDEX idx_user_sender (user_id, sender_type);
ALTER TABLE chat_messages ADD INDEX idx_read (is_read);
