-- Add columns for view control
ALTER TABLE searches 
ADD COLUMN view_count INT DEFAULT 0 AFTER source,
ADD COLUMN can_view_again BOOLEAN DEFAULT TRUE AFTER view_count,
ADD COLUMN admin_locked BOOLEAN DEFAULT FALSE AFTER can_view_again;

-- Add settings table for admin controls
CREATE TABLE IF NOT EXISTS search_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default setting
INSERT INTO search_settings (setting_key, setting_value) 
VALUES ('allow_repeat_views', '1')
ON DUPLICATE KEY UPDATE setting_value = setting_value;
