<?php
/**
 * Cron Script: Auto-expire subscriptions
 * Run this script daily via cron job
 * Example cron: 0 0 * * * php /path/to/expire-subscriptions.php
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../app/models/Subscription.php';

$subscriptionModel = new Subscription();
$expiredCount = $subscriptionModel->expireOldSubscriptions();

echo "Expired $expiredCount subscription(s) on " . date('Y-m-d H:i:s') . "\n";

// Log to file
$logFile = __DIR__ . '/../logs/cron.log';
$logDir = dirname($logFile);
if (!is_dir($logDir)) {
    mkdir($logDir, 0755, true);
}
file_put_contents($logFile, date('Y-m-d H:i:s') . " - Expired $expiredCount subscription(s)\n", FILE_APPEND);
