<?php
require_once __DIR__ . '/Database.php';

class Alert {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function logAlert($title, $message, $type, $userId = null) {
        $stmt = $this->db->prepare("INSERT INTO alerts_log (user_id, title, message, type) VALUES (?, ?, ?, ?)");
        return $stmt->execute([$userId, $title, $message, $type]);
    }

    public function getAllAlerts($limit = 100) {
        $stmt = $this->db->prepare("SELECT * FROM alerts_log ORDER BY created_at DESC LIMIT ?");
        $stmt->execute([$limit]);
        return $stmt->fetchAll();
    }
    
    public function getUserAlerts($userId, $limit = 50) {
        $stmt = $this->db->prepare("SELECT * FROM alerts_log WHERE user_id = ? ORDER BY created_at DESC LIMIT ?");
        $stmt->execute([$userId, $limit]);
        return $stmt->fetchAll();
    }

    public function getAlertsByType($type, $limit = 50) {
        $stmt = $this->db->prepare("SELECT * FROM alerts_log WHERE type = ? ORDER BY created_at DESC LIMIT ?");
        $stmt->execute([$type, $limit]);
        return $stmt->fetchAll();
    }

    public function getTotalAlerts() {
        $stmt = $this->db->query("SELECT COUNT(*) as total FROM alerts_log");
        return $stmt->fetch()['total'];
    }

    public function getTodayAlerts() {
        $stmt = $this->db->query("SELECT COUNT(*) as total FROM alerts_log WHERE DATE(created_at) = CURDATE()");
        return $stmt->fetch()['total'];
    }
}
