<?php
require_once __DIR__ . '/Database.php';

class Payment {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function createPayment($userId, $planId, $razorpayOrderId, $amount) {
        $stmt = $this->db->prepare("INSERT INTO payments (user_id, plan_id, razorpay_order_id, amount, status) VALUES (?, ?, ?, ?, 'pending')");
        $stmt->execute([$userId, $planId, $razorpayOrderId, $amount]);
        return $this->db->lastInsertId();
    }

    public function updatePaymentSuccess($orderId, $paymentId, $signature) {
        $stmt = $this->db->prepare("UPDATE payments SET razorpay_payment_id = ?, razorpay_signature = ?, status = 'success' WHERE razorpay_order_id = ?");
        return $stmt->execute([$paymentId, $signature, $orderId]);
    }

    public function updatePaymentFailed($orderId) {
        $stmt = $this->db->prepare("UPDATE payments SET status = 'failed' WHERE razorpay_order_id = ?");
        return $stmt->execute([$orderId]);
    }

    public function getPaymentByOrderId($orderId) {
        $stmt = $this->db->prepare("SELECT * FROM payments WHERE razorpay_order_id = ?");
        $stmt->execute([$orderId]);
        return $stmt->fetch();
    }

    public function getUserPayments($userId) {
        $stmt = $this->db->prepare("
            SELECT p.*, pl.name as plan_name 
            FROM payments p 
            JOIN plans pl ON p.plan_id = pl.id 
            WHERE p.user_id = ? 
            ORDER BY p.created_at DESC
        ");
        $stmt->execute([$userId]);
        return $stmt->fetchAll();
    }

    public function getAllPayments() {
        $stmt = $this->db->query("
            SELECT p.*, u.name as user_name, u.email, pl.name as plan_name 
            FROM payments p 
            JOIN users u ON p.user_id = u.id 
            JOIN plans pl ON p.plan_id = pl.id 
            ORDER BY p.created_at DESC
        ");
        return $stmt->fetchAll();
    }

    public function getTotalRevenue() {
        $stmt = $this->db->query("SELECT SUM(amount) as total FROM payments WHERE status = 'success'");
        $result = $stmt->fetch();
        return $result['total'] ?? 0;
    }

    public function getTodayRevenue() {
        $stmt = $this->db->query("SELECT SUM(amount) as total FROM payments WHERE status = 'success' AND DATE(created_at) = CURDATE()");
        $result = $stmt->fetch();
        return $result['total'] ?? 0;
    }
}
