<?php
require_once __DIR__ . '/Database.php';

class Plan {
    private $db;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function getAllPlans() {
        $stmt = $this->db->query("SELECT * FROM plans ORDER BY price ASC");
        return $stmt->fetchAll();
    }

    public function getActivePlans() {
        $stmt = $this->db->query("SELECT * FROM plans WHERE status = 'active' ORDER BY price ASC");
        return $stmt->fetchAll();
    }

    public function getPlanById($id) {
        $stmt = $this->db->prepare("SELECT * FROM plans WHERE id = ?");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public function createPlan($name, $description, $price, $duration_days, $search_limit) {
        $stmt = $this->db->prepare("INSERT INTO plans (name, description, price, duration_days, search_limit) VALUES (?, ?, ?, ?, ?)");
        return $stmt->execute([$name, $description, $price, $duration_days, $search_limit]);
    }

    public function updatePlan($id, $name, $description, $price, $duration_days, $search_limit, $status) {
        $stmt = $this->db->prepare("UPDATE plans SET name = ?, description = ?, price = ?, duration_days = ?, search_limit = ?, status = ? WHERE id = ?");
        return $stmt->execute([$name, $description, $price, $duration_days, $search_limit, $status, $id]);
    }

    public function deletePlan($id) {
        $stmt = $this->db->prepare("DELETE FROM plans WHERE id = ?");
        return $stmt->execute([$id]);
    }

    public function updatePlanStatus($id, $status) {
        $stmt = $this->db->prepare("UPDATE plans SET status = ? WHERE id = ?");
        return $stmt->execute([$status, $id]);
    }
}
