<?php
session_start();
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../app/models/User.php';
require_once __DIR__ . '/../../app/models/Subscription.php';
require_once __DIR__ . '/../../app/models/Search.php';
require_once __DIR__ . '/../../app/models/Payment.php';

// Check if user is admin
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

$userModel = new User();
$subscriptionModel = new Subscription();
$searchModel = new Search();
$paymentModel = new Payment();

// Get statistics
$totalUsers = $userModel->getTotalUsers();
$activeUsers = $userModel->getActiveUsers();
$activeSubscriptions = $subscriptionModel->getTotalActiveSubscriptions();
$totalSearches = $searchModel->getTotalSearches();
$todaySearches = $searchModel->getTodaySearches();
$totalRevenue = $paymentModel->getTotalRevenue();
$todayRevenue = $paymentModel->getTodayRevenue();
$searchStats = $searchModel->getSearchStats();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="container">
            <a href="dashboard.php" class="navbar-brand">🔐 Admin Panel</a>
            <ul class="navbar-menu">
                <li><a href="dashboard.php">Dashboard</a></li>
                <li><a href="users.php">Users</a></li>
                <li><a href="plans.php">Plans</a></li>
                <li><a href="subscriptions.php">Subscriptions</a></li>
                <li><a href="payments.php">Payments</a></li>
                <li><a href="searches.php">Searches</a></li>
                <li><a href="chat.php">💬 Chat</a></li>
                <li><a href="alerts.php">Alerts</a></li>
                <li><a href="../logout.php" class="btn btn-danger">Logout</a></li>
            </ul>
        </div>
    </nav>

    <div class="container mt-4">
        <!-- Welcome Section -->
        <div class="glass-card mb-4" data-aos="fade-up">
            <h2 class="gradient-text">Admin Dashboard 👨‍💼</h2>
            <p style="opacity: 0.8;">Welcome back, <?php echo htmlspecialchars($_SESSION['user_name']); ?>!</p>
        </div>

        <!-- Main Stats -->
        <div class="row">
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                <div class="stat-card">
                    <h3 class="neon-text"><?php echo $totalUsers; ?></h3>
                    <p>Total Users</p>
                    <small style="opacity: 0.7;"><?php echo $activeUsers; ?> Active</small>
                </div>
            </div>
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                <div class="stat-card">
                    <h3 class="neon-text"><?php echo $activeSubscriptions; ?></h3>
                    <p>Active Subscriptions</p>
                </div>
            </div>
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                <div class="stat-card">
                    <h3 class="neon-text"><?php echo $totalSearches; ?></h3>
                    <p>Total Searches</p>
                    <small style="opacity: 0.7;"><?php echo $todaySearches; ?> Today</small>
                </div>
            </div>
        </div>

        <!-- Revenue Stats -->
        <div class="row mt-4">
            <div class="col-md-6" data-aos="fade-up" data-aos-delay="100">
                <div class="stat-card">
                    <h3 style="background: var(--success-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">
                        ₹<?php echo number_format($totalRevenue, 2); ?>
                    </h3>
                    <p>Total Revenue</p>
                </div>
            </div>
            <div class="col-md-6" data-aos="fade-up" data-aos-delay="200">
                <div class="stat-card">
                    <h3 style="background: var(--success-gradient); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">
                        ₹<?php echo number_format($todayRevenue, 2); ?>
                    </h3>
                    <p>Today's Revenue</p>
                </div>
            </div>
        </div>

        <!-- Search Stats -->
        <div class="mt-4" data-aos="fade-up">
            <h3 class="gradient-text mb-3">Search Statistics</h3>
            <div class="row">
                <div class="col-md-4">
                    <div class="glass-card text-center">
                        <h3 style="color: var(--neon-blue);"><?php echo $searchStats['mobile_searches'] ?? 0; ?></h3>
                        <p>Mobile Searches</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="glass-card text-center">
                        <h3 style="color: var(--neon-blue);"><?php echo $searchStats['aadhaar_searches'] ?? 0; ?></h3>
                        <p>Aadhaar Searches</p>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="glass-card text-center">
                        <h3 style="color: var(--neon-blue);"><?php echo $searchStats['cache_searches'] ?? 0; ?></h3>
                        <p>Cache Hits</p>
                        <small style="opacity: 0.7;"><?php echo $searchStats['api_searches'] ?? 0; ?> API Calls</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="mt-4" data-aos="fade-up">
            <h3 class="gradient-text mb-3">Quick Actions</h3>
            <div class="row">
                <div class="col-md-4">
                    <a href="users.php" class="glass-card text-center" style="display: block; text-decoration: none; color: inherit;">
                        <div style="font-size: 48px; margin-bottom: 15px;">👥</div>
                        <h4>Manage Users</h4>
                        <p style="opacity: 0.7;">View and manage all users</p>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="plans.php" class="glass-card text-center" style="display: block; text-decoration: none; color: inherit;">
                        <div style="font-size: 48px; margin-bottom: 15px;">📦</div>
                        <h4>Manage Plans</h4>
                        <p style="opacity: 0.7;">Create and edit subscription plans</p>
                    </a>
                </div>
                <div class="col-md-4">
                    <a href="payments.php" class="glass-card text-center" style="display: block; text-decoration: none; color: inherit;">
                        <div style="font-size: 48px; margin-bottom: 15px;">💰</div>
                        <h4>View Payments</h4>
                        <p style="opacity: 0.7;">Track all payment transactions</p>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="../assets/js/toast.js"></script>
    <script>
        AOS.init({
            duration: 1000,
            once: true
        });
        
        // Check for login success from session
        <?php if (isset($_SESSION['login_success']) && $_SESSION['login_success']): ?>
            showSuccess('🎉 Welcome back, <?php echo htmlspecialchars($_SESSION['login_user_name'] ?? 'Admin'); ?>! Login successful!', 5000);
            <?php 
            unset($_SESSION['login_success']);
            unset($_SESSION['login_user_name']);
            ?>
        <?php endif; ?>
    </script>
</body>
</html>
