<?php
session_start();
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../app/models/Search.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

$searchModel = new Search();
$searches = $searchModel->getAllSearches(200);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Searches - Admin Panel</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <a href="dashboard.php" class="navbar-brand">🔐 Admin Panel</a>
            <ul class="navbar-menu">
                <li><a href="dashboard.php">Dashboard</a></li>
                <li><a href="users.php">Users</a></li>
                <li><a href="plans.php">Plans</a></li>
                <li><a href="subscriptions.php">Subscriptions</a></li>
                <li><a href="payments.php">Payments</a></li>
                <li><a href="searches.php">Searches</a></li>
                <li><a href="alerts.php">Alerts</a></li>
                <li><a href="../logout.php" class="btn btn-danger">Logout</a></li>
            </ul>
        </div>
    </nav>

    <div class="container mt-4">
        <h2 class="gradient-text mb-4">All Searches</h2>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Type</th>
                        <th>Query</th>
                        <th>Source</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($searches as $search): ?>
                        <tr>
                            <td><?php echo $search['id']; ?></td>
                            <td><?php echo htmlspecialchars($search['user_name']); ?><br><small><?php echo htmlspecialchars($search['email']); ?></small></td>
                            <td>
                                <span class="badge badge-info">
                                    <?php echo strtoupper($search['search_type']); ?>
                                </span>
                            </td>
                            <td><?php echo htmlspecialchars($search['query_value']); ?></td>
                            <td>
                                <span class="badge <?php echo $search['source'] === 'cache' ? 'badge-success' : 'badge-warning'; ?>">
                                    <?php echo strtoupper($search['source']); ?>
                                </span>
                            </td>
                            <td><?php echo date('d M Y H:i', strtotime($search['created_at'])); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>
