<?php
session_start();
header('Content-Type: application/json');
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../app/models/Database.php';
require_once __DIR__ . '/../../app/models/ActivityLog.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$activityLog = new ActivityLog();
$action = $_GET['action'] ?? $_POST['action'] ?? '';

switch ($action) {
    case 'log':
        // Log new activity
        $data = json_decode(file_get_contents('php://input'), true);
        $activityAction = $data['action'] ?? '';
        $description = $data['description'] ?? '';
        $additionalData = $data['data'] ?? [];
        
        if (empty($activityAction)) {
            echo json_encode(['error' => 'Action required']);
            exit;
        }
        
        $result = $activityLog->logActivity(
            $_SESSION['user_id'],
            $activityAction,
            $description,
            $additionalData
        );
        
        echo json_encode(['success' => $result]);
        break;
        
    case 'get':
        // Get user activities
        $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;
        $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
        
        $activities = $activityLog->getUserActivities($_SESSION['user_id'], $limit, $offset);
        
        // Format activities
        foreach ($activities as &$activity) {
            $activity['icon'] = ActivityLog::getActivityIcon($activity['action']);
            $activity['label'] = ActivityLog::getActivityLabel($activity['action']);
            $activity['data_parsed'] = json_decode($activity['data'], true);
        }
        
        echo json_encode([
            'success' => true,
            'activities' => $activities,
            'count' => count($activities)
        ]);
        break;
        
    case 'stats':
        // Get activity statistics
        $stats = $activityLog->getActivityStats($_SESSION['user_id']);
        
        foreach ($stats as &$stat) {
            $stat['icon'] = ActivityLog::getActivityIcon($stat['action']);
            $stat['label'] = ActivityLog::getActivityLabel($stat['action']);
        }
        
        echo json_encode([
            'success' => true,
            'stats' => $stats
        ]);
        break;
        
    case 'recent':
        // Get recent activities (last 24 hours)
        $hours = isset($_GET['hours']) ? (int)$_GET['hours'] : 24;
        $activities = $activityLog->getRecentActivities($_SESSION['user_id'], $hours);
        
        foreach ($activities as &$activity) {
            $activity['icon'] = ActivityLog::getActivityIcon($activity['action']);
            $activity['label'] = ActivityLog::getActivityLabel($activity['action']);
        }
        
        echo json_encode([
            'success' => true,
            'activities' => $activities,
            'hours' => $hours
        ]);
        break;
        
    default:
        echo json_encode(['error' => 'Invalid action']);
        break;
}
