// Theme Toggle Functionality
(function() {
    'use strict';
    
    // Get saved theme or default to dark
    const savedTheme = localStorage.getItem('gravity-theme') || 'dark';
    
    // Apply theme on page load
    if (savedTheme === 'light') {
        document.body.classList.add('light-theme');
    }
    
    // Create theme toggle button
    function createThemeToggle() {
        const button = document.createElement('button');
        button.className = 'theme-toggle';
        button.setAttribute('aria-label', 'Toggle theme');
        button.setAttribute('title', 'Toggle Dark/Light Mode');
        updateThemeIcon(button);
        
        button.addEventListener('click', toggleTheme);
        document.body.appendChild(button);
    }
    
    // Update button icon based on current theme
    function updateThemeIcon(button) {
        const isLight = document.body.classList.contains('light-theme');
        button.innerHTML = isLight ? '🌙' : '☀️';
    }
    
    // Toggle theme
    function toggleTheme() {
        const button = document.querySelector('.theme-toggle');
        document.body.classList.toggle('light-theme');
        
        const isLight = document.body.classList.contains('light-theme');
        const theme = isLight ? 'light' : 'dark';
        
        // Save preference
        localStorage.setItem('gravity-theme', theme);
        
        // Update icon
        updateThemeIcon(button);
        
        // Show toast notification
        if (typeof showSuccess === 'function') {
            showSuccess(`${isLight ? '☀️ Light' : '🌙 Dark'} mode activated!`, 2000);
        }
        
        // Log activity
        logActivity('theme_change', { theme: theme });
    }
    
    // Log activity (if activity logging is enabled)
    function logActivity(action, data) {
        if (typeof fetch !== 'undefined') {
            fetch('api/log-activity.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    action: action,
                    data: data,
                    timestamp: new Date().toISOString()
                })
            }).catch(err => console.log('Activity log failed:', err));
        }
    }
    
    // Initialize on DOM ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', createThemeToggle);
    } else {
        createThemeToggle();
    }
    
    // Keyboard shortcut: Ctrl+Shift+T
    document.addEventListener('keydown', function(e) {
        if (e.ctrlKey && e.shiftKey && e.key === 'T') {
            e.preventDefault();
            toggleTheme();
        }
    });
    
})();
