/**
 * Toast Notification System
 * Simple, auto-hiding toast notifications
 */

// Create toast container if it doesn't exist
function createToastContainer() {
    let container = document.getElementById('toast-container');
    if (!container) {
        container = document.createElement('div');
        container.id = 'toast-container';
        container.className = 'toast-container';
        document.body.appendChild(container);
    }
    return container;
}

// Show toast notification
function showToast(message, type = 'info', duration = 4000) {
    const container = createToastContainer();

    // Icons for different types
    const icons = {
        success: '✓',
        error: '✕',
        warning: '⚠',
        info: 'ℹ'
    };

    // Titles for different types
    const titles = {
        success: 'Success',
        error: 'Error',
        warning: 'Warning',
        info: 'Info'
    };

    // Create toast element
    const toast = document.createElement('div');
    toast.className = `toast toast-${type}`;

    toast.innerHTML = `
        <div class="toast-header">
            <span class="toast-icon">${icons[type] || icons.info}</span>
            <span class="toast-title">${titles[type] || titles.info}</span>
            <button class="toast-close" onclick="closeToast(this)">×</button>
        </div>
        <div class="toast-body">${message}</div>
    `;

    // Add to container
    container.appendChild(toast);

    // Auto hide after duration
    setTimeout(() => {
        hideToast(toast);
    }, duration);
}

// Hide toast with animation
function hideToast(toast) {
    toast.classList.add('hiding');
    setTimeout(() => {
        if (toast.parentElement) {
            toast.parentElement.removeChild(toast);
        }
    }, 300);
}

// Close toast manually
function closeToast(button) {
    const toast = button.closest('.toast');
    if (toast) {
        hideToast(toast);
    }
}

// Convenience functions
function showSuccess(message, duration = 4000) {
    showToast(message, 'success', duration);
}

function showError(message, duration = 4000) {
    showToast(message, 'error', duration);
}

function showWarning(message, duration = 4000) {
    showToast(message, 'warning', duration);
}

function showInfo(message, duration = 4000) {
    showToast(message, 'info', duration);
}
